/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Mix;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Stars3D
extends ControlsSurface {
    private static Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.WHITE};
    private static AffineTransform at = AffineTransform.getTranslateInstance(-5.0, -5.0);
    private Shape shape;
    private Shape tshape;
    private Shape ribbon;
    protected int fontSize = 72;
    protected String text = "Java2D";
    protected int numStars = 300;
    private DemoControls controls;

    public Stars3D() {
        this.setBackground(Color.BLACK);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        for (int i = 0; i < this.numStars; ++i) {
            graphics2D.setColor(colors[i % 3]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)Math.random()));
            ((Rectangle2D)double_).setRect((double)n * Math.random(), (double)n2 * Math.random(), 2.0, 2.0);
            graphics2D.fill(double_);
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("serif.bolditalic", 0, this.fontSize);
        this.shape = font.createGlyphVector(fontRenderContext, this.text).getOutline();
        this.tshape = at.createTransformedShape(this.shape);
        PathIterator pathIterator = this.shape.getPathIterator(null);
        float[] fArray = new float[6];
        float[] fArray2 = new float[6];
        GeneralPath generalPath = new GeneralPath(1);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    at.transform(fArray, 0, fArray2, 0, 1);
                    f = fArray[0];
                    f2 = fArray[1];
                    f3 = fArray2[0];
                    f4 = fArray2[1];
                    f5 = f;
                    f6 = f2;
                    f7 = f3;
                    f8 = f4;
                    break;
                }
                case 1: {
                    at.transform(fArray, 0, fArray2, 0, 1);
                    if (Line2D.relativeCCW(f, f2, f3, f4, fArray[0], fArray[1]) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(fArray[0], fArray[1]);
                        generalPath.lineTo(fArray2[0], fArray2[1]);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(fArray2[0], fArray2[1]);
                        generalPath.lineTo(fArray[0], fArray[1]);
                        generalPath.lineTo(f, f2);
                    }
                    f = fArray[0];
                    f2 = fArray[1];
                    f3 = fArray2[0];
                    f4 = fArray2[1];
                    break;
                }
                case 2: {
                    at.transform(fArray, 0, fArray2, 0, 2);
                    if (Line2D.relativeCCW(f, f2, f3, f4, fArray[2], fArray[3]) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                        generalPath.lineTo(fArray2[2], fArray2[3]);
                        generalPath.quadTo(fArray2[0], fArray2[1], f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                        generalPath.lineTo(fArray[2], fArray[3]);
                        generalPath.quadTo(fArray[0], fArray[1], f, f2);
                    }
                    f = fArray[2];
                    f2 = fArray[3];
                    f3 = fArray2[2];
                    f4 = fArray2[3];
                    break;
                }
                case 3: {
                    at.transform(fArray, 0, fArray2, 0, 3);
                    if (Line2D.relativeCCW(f, f2, f3, f4, fArray[4], fArray[5]) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        generalPath.lineTo(fArray2[4], fArray2[5]);
                        generalPath.curveTo(fArray2[2], fArray2[3], fArray2[0], fArray2[1], f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.curveTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3], fArray2[4], fArray2[5]);
                        generalPath.lineTo(fArray[4], fArray[5]);
                        generalPath.curveTo(fArray[2], fArray[3], fArray[0], fArray[1], f, f2);
                    }
                    f = fArray[4];
                    f2 = fArray[5];
                    f3 = fArray2[4];
                    f4 = fArray2[5];
                    break;
                }
                case 4: {
                    if (Line2D.relativeCCW(f, f2, f3, f4, f5, f6) < 0) {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f5, f6);
                        generalPath.lineTo(f7, f8);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(f, f2);
                    } else {
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f3, f4);
                        generalPath.lineTo(f7, f8);
                        generalPath.lineTo(f5, f6);
                        generalPath.lineTo(f, f2);
                    }
                    f = f5;
                    f2 = f6;
                    f3 = f7;
                    f4 = f8;
                }
            }
            pathIterator.next();
        }
        this.ribbon = generalPath;
        if (this.composite != null) {
            graphics2D.setComposite(this.composite);
        } else {
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
        Rectangle rectangle = this.shape.getBounds();
        graphics2D.translate((double)n * 0.5 - (double)rectangle.width * 0.5, (double)n2 * 0.5 + (double)rectangle.height * 0.5);
        graphics2D.setColor(Color.BLUE);
        graphics2D.fill(this.tshape);
        graphics2D.setColor(new Color(255, 255, 255, 200));
        graphics2D.fill(this.ribbon);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.shape);
        graphics2D.setColor(Color.BLUE);
        graphics2D.draw(this.shape);
    }

    public static void main(String[] stringArray) {
        Stars3D.createDemoFrame(new Stars3D());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Stars3D demo;
        JTextField tf1;
        JTextField tf2;

        public DemoControls(Stars3D stars3D) {
            super(stars3D.name);
            this.demo = stars3D;
            JLabel jLabel = new JLabel("  Text:");
            jLabel.setForeground(Color.BLACK);
            this.add(jLabel);
            this.tf1 = new JTextField(stars3D.text);
            this.add(this.tf1);
            this.tf1.setPreferredSize(new Dimension(60, 20));
            this.tf1.addActionListener(this);
            jLabel = new JLabel("  Size:");
            jLabel.setForeground(Color.BLACK);
            this.add(jLabel);
            this.tf2 = new JTextField(String.valueOf(stars3D.fontSize));
            this.add(this.tf2);
            this.tf2.setPreferredSize(new Dimension(30, 20));
            this.tf2.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource().equals(this.tf1)) {
                    this.demo.text = this.tf1.getText().trim();
                } else if (actionEvent.getSource().equals(this.tf2)) {
                    this.demo.fontSize = Integer.parseInt(this.tf2.getText().trim());
                    if (this.demo.fontSize < 10) {
                        this.demo.fontSize = 10;
                    }
                }
                this.demo.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 37);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            try {
                Thread.sleep(999L);
            }
            catch (Exception exception) {
                return;
            }
            int n = this.getSize().width / 4;
            int[] nArray = new int[]{n, n};
            String[] stringArray = new String[]{"JAVA", "J2D"};
            while (this.thread == thread) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.demo.fontSize = nArray[i];
                    this.tf2.setText(String.valueOf(this.demo.fontSize));
                    this.demo.text = stringArray[i];
                    this.tf1.setText(this.demo.text);
                    this.demo.repaint();
                    try {
                        Thread.sleep(5555L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

