/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.AbstractHeapGraphWriter;

public class HeapGXLWriter
extends AbstractHeapGraphWriter {
    private static final String ENCODING = "UTF-8";
    private List refFields;
    private boolean isArray;
    private PrintWriter out;

    public void write(String fileName) throws IOException {
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
        super.write();
        if (this.out.checkError()) {
            throw new IOException();
        }
        this.out.flush();
    }

    protected void writeHeapHeader() throws IOException {
        this.out.print("<?xml version='1.0' encoding='");
        this.out.print(ENCODING);
        this.out.println("'?>");
        this.out.println("<gxl>");
        this.out.println("<graph id='JavaHeap'>");
        this.writeAttribute("creation-date", "string", new Date().toString());
        this.writeVMInfo();
        this.out.print("<node id='");
        this.out.print(HeapGXLWriter.getID(null));
        this.out.println("'/>");
    }

    protected void writeObjectHeader(Oop oop) throws IOException {
        this.refFields = new ArrayList();
        this.isArray = oop.isArray();
        this.writeEdge(oop, oop.getKlass().getJavaMirror(), "instanceof");
        this.out.print("<node id='");
        this.out.print(HeapGXLWriter.getID(oop));
        this.out.println("'>");
    }

    protected void writeObjectFooter(Oop oop) throws IOException {
        this.out.println("</node>");
        Iterator itr = this.refFields.iterator();
        while (itr.hasNext()) {
            OopField field = (OopField)itr.next();
            Oop ref = field.getValue(oop);
            String name = field.getID().getName();
            name = this.isArray ? "element" + name : HeapGXLWriter.identifierToXMLName(name);
            this.writeEdge(oop, ref, name);
        }
        this.refFields = null;
    }

    protected void writeObjectArray(ObjArray array) throws IOException {
        this.writeObjectHeader(array);
        this.writeArrayLength(array);
        this.writeObjectFields(array);
        this.writeObjectFooter(array);
    }

    protected void writePrimitiveArray(TypeArray array) throws IOException {
        this.writeObjectHeader(array);
        this.writeArrayLength(array);
        this.out.println("\t<attr name='elements'>");
        TypeArrayKlass klass = (TypeArrayKlass)array.getKlass();
        if (klass.getElementType() == 5) {
            this.out.print("\t<string>");
            this.out.print(HeapGXLWriter.escapeXMLChars(OopUtilities.charArrayToString(array)));
            this.out.println("</string>");
        } else {
            this.out.println("\t<seq>");
            this.writeObjectFields(array);
            this.out.println("\t</seq>");
        }
        this.out.println("\t</attr>");
        this.writeObjectFooter(array);
    }

    protected void writeClass(Instance instance) throws IOException {
        this.writeObjectHeader(instance);
        Klass reflectedType = OopUtilities.classOopToKlass(instance);
        boolean isInstanceKlass = reflectedType instanceof InstanceKlass;
        if (reflectedType != null) {
            Symbol name = reflectedType.getName();
            if (name != null) {
                this.writeAttribute("class-name", "string", name.asString());
            }
            if (isInstanceKlass) {
                long sizeInBytes = reflectedType.getLayoutHelper();
                this.writeAttribute("object-size", "int", Long.toString(sizeInBytes));
                this.writeObjectFields(reflectedType);
            }
        }
        this.out.println("</node>");
        if (reflectedType != null) {
            Klass superType = reflectedType.getSuper();
            Instance superMirror = superType == null ? null : superType.getJavaMirror();
            this.writeEdge(instance, superMirror, "extends");
            if (isInstanceKlass) {
                InstanceKlass ik = (InstanceKlass)reflectedType;
                ObjArray interfaces = ik.getLocalInterfaces();
                int len = (int)interfaces.getLength();
                for (int i = 0; i < len; ++i) {
                    Klass k = (Klass)interfaces.getObjAt(i);
                    this.writeEdge(instance, k.getJavaMirror(), "implements");
                }
                Oop loader = ik.getClassLoader();
                this.writeEdge(instance, loader, "loaded-by");
                ObjArray signers = ik.getSigners();
                this.writeEdge(instance, signers, "signed-by");
                Oop protectionDomain = ik.getProtectionDomain();
                this.writeEdge(instance, protectionDomain, "protection-domain");
                Iterator itr = this.refFields.iterator();
                while (itr.hasNext()) {
                    OopField field = (OopField)itr.next();
                    Oop ref = field.getValue(reflectedType);
                    String name = field.getID().getName();
                    this.writeEdge(instance, ref, HeapGXLWriter.identifierToXMLName(name));
                }
            }
        }
        this.refFields = null;
    }

    protected void writeReferenceField(Oop oop, OopField field) throws IOException {
        this.refFields.add(field);
    }

    protected void writeByteField(Oop oop, ByteField field) throws IOException {
        this.writeField(field, "int", "B", Byte.toString(field.getValue(oop)));
    }

    protected void writeCharField(Oop oop, CharField field) throws IOException {
        this.writeField(field, "string", "C", HeapGXLWriter.escapeXMLChars(Character.toString(field.getValue(oop))));
    }

    protected void writeBooleanField(Oop oop, BooleanField field) throws IOException {
        this.writeField(field, "bool", "Z", Boolean.toString(field.getValue(oop)));
    }

    protected void writeShortField(Oop oop, ShortField field) throws IOException {
        this.writeField(field, "int", "S", Short.toString(field.getValue(oop)));
    }

    protected void writeIntField(Oop oop, IntField field) throws IOException {
        this.writeField(field, "int", "I", Integer.toString(field.getValue(oop)));
    }

    protected void writeLongField(Oop oop, LongField field) throws IOException {
        this.writeField(field, "int", "J", Long.toString(field.getValue(oop)));
    }

    protected void writeFloatField(Oop oop, FloatField field) throws IOException {
        this.writeField(field, "float", "F", Float.toString(field.getValue(oop)));
    }

    protected void writeDoubleField(Oop oop, DoubleField field) throws IOException {
        this.writeField(field, "float", "D", Double.toString(field.getValue(oop)));
    }

    protected void writeHeapFooter() throws IOException {
        this.out.println("</graph>");
        this.out.println("</gxl>");
    }

    private static String identifierToXMLName(String name) {
        return name.replace('$', '_');
    }

    private static String escapeXMLChars(String s) {
        StringBuffer result = null;
        int max = s.length();
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            String replacement = null;
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\'') {
                replacement = "&apos;";
            } else if (c < ' ' || c > '\ud7ff' && c < '\ue000' || c == '\ufffe' || c == '\uffff') {
                replacement = "<![CDATA[&#x" + Integer.toHexString(c) + ";]]>";
            }
            if (replacement == null) continue;
            if (result == null) {
                result = new StringBuffer(s);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    private static String getID(Oop oop) {
        if (oop == null) {
            return "ID_NULL";
        }
        return "ID_" + oop.getHandle().toString();
    }

    private void writeArrayLength(Array array) throws IOException {
        this.writeAttribute("length", "int", Integer.toString((int)array.getLength()));
    }

    private void writeAttribute(String name, String type, String value) {
        this.out.print("\t<attr name='");
        this.out.print(name);
        this.out.print("'><");
        this.out.print(type);
        this.out.print('>');
        this.out.print(value);
        this.out.print("</");
        this.out.print(type);
        this.out.println("></attr>");
    }

    private void writeEdge(Oop from, Oop to, String name) throws IOException {
        this.out.print("<edge from='");
        this.out.print(HeapGXLWriter.getID(from));
        this.out.print("' to='");
        this.out.print(HeapGXLWriter.getID(to));
        this.out.println("'>");
        this.writeAttribute("name", "string", name);
        this.out.println("</edge>");
    }

    private void writeField(Field field, String type, String kind, String value) throws IOException {
        if (this.isArray) {
            this.out.print('\t');
        } else {
            this.out.print("\t<attr name='");
            String name = field.getID().getName();
            this.out.print(HeapGXLWriter.identifierToXMLName(name));
            this.out.print("' kind='");
            this.out.print(kind);
            this.out.print("'>");
        }
        this.out.print('<');
        this.out.print(type);
        this.out.print('>');
        this.out.print(value);
        this.out.print("</");
        this.out.print(type);
        this.out.print('>');
        if (this.isArray) {
            this.out.println();
        } else {
            this.out.println("</attr>");
        }
    }

    private void writeVMInfo() throws IOException {
        VM vm = VM.getVM();
        this.writeAttribute("vm-version", "string", vm.getVMRelease());
        this.writeAttribute("vm-type", "string", vm.isClientCompiler() ? "client" : (vm.isServerCompiler() ? "server" : "core"));
        this.writeAttribute("os", "string", vm.getOS());
        this.writeAttribute("cpu", "string", vm.getCPU());
        this.writeAttribute("pointer-size", "string", Integer.toString((int)vm.getOopSize() * 8));
    }
}

