/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.CompactingPermGenGen;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Mark;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopPrinter;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Oop {
    private OopHandle handle;
    private ObjectHeap heap;
    private static long headerSize;
    private static CIntField mark;
    private static OopField klass;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("oopDesc");
        mark = new CIntField(type.getCIntegerField("_mark"), 0L);
        klass = new OopField(type.getOopField("_klass"), 0L);
        headerSize = type.getSize();
    }

    Oop(OopHandle handle, ObjectHeap heap) {
        this.handle = handle;
        this.heap = heap;
    }

    ObjectHeap getHeap() {
        return this.heap;
    }

    public OopHandle getHandle() {
        return this.handle;
    }

    public static long getHeaderSize() {
        return headerSize;
    }

    public boolean isShared() {
        return CompactingPermGenGen.isShared(this.handle);
    }

    public boolean isSharedReadOnly() {
        return CompactingPermGenGen.isSharedReadOnly(this.handle);
    }

    public boolean isSharedReadWrite() {
        return CompactingPermGenGen.isSharedReadWrite(this.handle);
    }

    public Mark getMark() {
        return new Mark(this.getHandle());
    }

    public Klass getKlass() {
        return (Klass)klass.getValue(this);
    }

    public boolean isA(Klass k) {
        return this.getKlass().isSubtypeOf(k);
    }

    public long getObjectSize() {
        Klass k = this.getKlass();
        if (k instanceof InstanceKlass) {
            return ((InstanceKlass)k).getSizeHelper() * VM.getVM().getAddressSize();
        }
        return Oop.getHeaderSize();
    }

    public boolean isInstance() {
        return false;
    }

    public boolean isInstanceRef() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObjArray() {
        return false;
    }

    public boolean isTypeArray() {
        return false;
    }

    public boolean isSymbol() {
        return false;
    }

    public boolean isKlass() {
        return false;
    }

    public boolean isThread() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isMethodData() {
        return false;
    }

    public boolean isConstantPool() {
        return false;
    }

    public boolean isConstantPoolCache() {
        return false;
    }

    public boolean isCompiledICHolder() {
        return false;
    }

    public static long alignObjectSize(long size) {
        return VM.getVM().alignUp(size, VM.getVM().getMinObjAlignmentInBytes());
    }

    public static long alignObjectOffset(long offset) {
        return VM.getVM().alignUp(offset, VM.getVM().getBytesPerLong());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Oop) {
            return this.getHandle().equals(((Oop)obj).getHandle());
        }
        return false;
    }

    public int hashCode() {
        return this.getHandle().hashCode();
    }

    public long identityHash() {
        Mark mark = this.getMark();
        if (mark.isUnlocked() && !mark.hasNoHash()) {
            return (int)mark.hash();
        }
        if (mark.isMarked()) {
            return (int)mark.hash();
        }
        return this.slowIdentityHash();
    }

    public long slowIdentityHash() {
        return VM.getVM().getObjectSynchronizer().identityHashValueFor(this);
    }

    public void iterate(OopVisitor visitor, boolean doVMFields) {
        visitor.setObj(this);
        visitor.prologue();
        this.iterateFields(visitor, doVMFields);
        visitor.epilogue();
    }

    void iterateFields(OopVisitor visitor, boolean doVMFields) {
        if (doVMFields) {
            visitor.doCInt(mark, true);
            visitor.doOop(klass, true);
        }
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printValue() {
        this.printValueOn(System.out);
    }

    public void printRaw() {
        this.printRawOn(System.out);
    }

    public static void printOopValueOn(Oop obj, PrintStream tty) {
        if (obj == null) {
            tty.print("null");
        } else {
            obj.printValueOn(tty);
            tty.print(" @ " + obj.getHandle());
        }
    }

    public static void printOopAddressOn(Oop obj, PrintStream tty) {
        if (obj == null) {
            tty.print("null");
        } else {
            tty.print(obj.getHandle().toString());
        }
    }

    public void printOn(PrintStream tty) {
        OopPrinter printer = new OopPrinter(tty);
        this.iterate(printer, true);
    }

    public void printValueOn(PrintStream tty) {
        try {
            tty.print("Oop for " + this.getKlass().getName().asString());
        }
        catch (NullPointerException e) {
            tty.print("Oop");
        }
    }

    public void printRawOn(PrintStream tty) {
        tty.print("Dumping raw memory for ");
        this.printValueOn(tty);
        tty.println();
        long size = this.getObjectSize() * 4L;
        for (long i = 0L; i < size; i += 4L) {
            long memVal = this.getHandle().getCIntegerAt(i, 4L, true);
            tty.println(Long.toHexString(memVal));
        }
    }

    public boolean verify() {
        return true;
    }

    static OopHandle getKlassForOopHandle(OopHandle handle) {
        if (handle == null) {
            return null;
        }
        return handle.getOopHandleAt(klass.getOffset());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Oop.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

