/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Checksum;

public class Adler32
implements Checksum {
    private static final int BASE = 65521;
    private int checksum;

    public Adler32() {
        this.reset();
    }

    public void reset() {
        this.checksum = 1;
    }

    public void update(int bval) {
        int s1 = this.checksum & 0xFFFF;
        int s2 = this.checksum >>> 16;
        s1 = (s1 + (bval & 0xFF)) % 65521;
        s2 = (s1 + s2) % 65521;
        this.checksum = (s2 << 16) + s1;
    }

    public void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    public void update(byte[] buf, int off, int len) {
        int s1 = this.checksum & 0xFFFF;
        int s2 = this.checksum >>> 16;
        while (len > 0) {
            int n = 3800;
            if (n > len) {
                n = len;
            }
            len -= n;
            while (--n >= 0) {
                s2 += (s1 += buf[off++] & 0xFF);
            }
            s1 %= 65521;
            s2 %= 65521;
        }
        this.checksum = s2 << 16 | s1;
    }

    public long getValue() {
        return (long)this.checksum & 0xFFFFFFFFL;
    }
}

