/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import sun.jvm.hotspot.tools.PStack;
import sun.jvm.hotspot.tools.StackTrace;
import sun.jvm.hotspot.tools.Tool;

public class JStack
extends Tool {
    private boolean mixedMode;
    private boolean concurrentLocks;

    public JStack(boolean mixedMode, boolean concurrentLocks) {
        this.mixedMode = mixedMode;
        this.concurrentLocks = concurrentLocks;
    }

    public JStack() {
        this(true, true);
    }

    protected boolean needsJavaPrefix() {
        return false;
    }

    public String getName() {
        return "jstack";
    }

    protected void printFlagsUsage() {
        System.out.println("    -l\tto print java.util.concurrent locks");
        System.out.println("    -m\tto print both java and native frames (mixed mode)");
        super.printFlagsUsage();
    }

    public void run() {
        Tool tool = null;
        tool = this.mixedMode ? new PStack(false, this.concurrentLocks) : new StackTrace(false, this.concurrentLocks);
        tool.setAgent(this.getAgent());
        tool.setDebugeeType(this.getDebugeeType());
        tool.run();
    }

    public static void main(String[] args) {
        boolean mixedMode = false;
        boolean concurrentLocks = false;
        int used = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-m")) {
                mixedMode = true;
                ++used;
                continue;
            }
            if (!args[i].equals("-l")) continue;
            concurrentLocks = true;
            ++used;
        }
        if (used != 0) {
            String[] newArgs = new String[args.length - used];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = args[i + used];
            }
            args = newArgs;
        }
        JStack jstack = new JStack(mixedMode, concurrentLocks);
        jstack.start(args);
        jstack.stop();
    }
}

