/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.linux_ia64;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.ia64.IA64ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.ia64.IA64Frame;
import sun.jvm.hotspot.runtime.ia64.IA64RegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class LinuxIA64JavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField lastJavaIFrameField;
    private static AddressField osThreadField;
    private static CIntegerField osThreadPThreadIDField;
    private static final long GUESS_SCAN_RANGE = 131072L;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        lastJavaIFrameField = type.getAddressField("_last_Java_iframe");
        osThreadField = type.getAddressField("_osthread");
        type = db.lookupType("OSThread");
        osThreadPThreadIDField = type.getCIntegerField("_pthread_id");
    }

    public Address getLastJavaIFrame(Address addr) {
        return lastJavaIFrameField.getValue(addr);
    }

    public Address getBaseOfStackPointer(Address addr) {
        return null;
    }

    public Address getLastJavaFP(Address addr) {
        return null;
    }

    public Address getLastJavaPC(Address addr) {
        return null;
    }

    public boolean isInterpretedFrame() {
        return true;
    }

    public Frame getLastFramePD(JavaThread thread, Address addr) {
        Address iframe = this.getLastJavaIFrame(addr);
        Address pc = thread.getLastJavaPC();
        if (iframe == null) {
            return null;
        }
        return new IA64Frame(thread.getLastJavaSP(), iframe, pc);
    }

    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new IA64RegisterMap(thread, updateMap);
    }

    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        return this.getLastFramePD(thread, addr);
    }

    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    public void printInfoOn(Address threadAddr, PrintStream tty) {
        tty.print("Thread id: ");
        this.printThreadIDOn(threadAddr, tty);
        tty.println("\nLastJavaIFrame: " + this.getLastJavaIFrame(threadAddr));
    }

    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        IA64ThreadContext context = (IA64ThreadContext)t.getContext();
        return context.getRegisterAsAddress(12);
    }

    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address pthreadIdAddr = osThreadAddr.addOffsetTo(osThreadPThreadIDField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(pthreadIdAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                LinuxIA64JavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

