/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.jdi.InterfaceTypeImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.oops.InstanceKlass;

public class ClassTypeImpl
extends ReferenceTypeImpl
implements ClassType {
    private SoftReference interfacesCache = null;
    private SoftReference allInterfacesCache = null;
    private SoftReference subclassesCache = null;

    protected ClassTypeImpl(VirtualMachine aVm, InstanceKlass aRef) {
        super(aVm, aRef);
    }

    public ClassType superclass() {
        InstanceKlass kk = (InstanceKlass)this.ref().getSuper();
        if (kk == null) {
            return null;
        }
        return (ClassType)((Object)this.vm.referenceType(kk));
    }

    public List interfaces() {
        List interfaces;
        List list = interfaces = this.interfacesCache != null ? (List)this.interfacesCache.get() : null;
        if (interfaces == null) {
            this.checkPrepared();
            interfaces = Collections.unmodifiableList(this.getInterfaces());
            this.interfacesCache = new SoftReference(interfaces);
        }
        return interfaces;
    }

    void addInterfaces(List list) {
        List immediate = this.interfaces();
        list.addAll(this.interfaces());
        Iterator iter = immediate.iterator();
        while (iter.hasNext()) {
            InterfaceTypeImpl interfaze = (InterfaceTypeImpl)iter.next();
            interfaze.addSuperinterfaces(list);
        }
        ClassTypeImpl superclass = (ClassTypeImpl)this.superclass();
        if (superclass != null) {
            superclass.addInterfaces(list);
        }
    }

    public List allInterfaces() {
        List allinterfaces;
        ArrayList arrayList = allinterfaces = this.allInterfacesCache != null ? (ArrayList)this.allInterfacesCache.get() : null;
        if (allinterfaces == null) {
            this.checkPrepared();
            allinterfaces = new ArrayList();
            this.addInterfaces(allinterfaces);
            allinterfaces = Collections.unmodifiableList(allinterfaces);
            this.allInterfacesCache = new SoftReference(allinterfaces);
        }
        return allinterfaces;
    }

    public List subclasses() {
        List<ReferenceType> subclasses;
        List list = subclasses = this.subclassesCache != null ? (ArrayList)this.subclassesCache.get() : null;
        if (subclasses == null) {
            List all = this.vm.allClasses();
            subclasses = new ArrayList(0);
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                ClassType clazz;
                ClassType superclass;
                ReferenceType refType = (ReferenceType)iter.next();
                if (!(refType instanceof ClassType) || (superclass = (clazz = (ClassType)refType).superclass()) == null || !superclass.equals(this)) continue;
                subclasses.add(refType);
            }
            subclasses = Collections.unmodifiableList(subclasses);
            this.subclassesCache = new SoftReference(subclasses);
        }
        return subclasses;
    }

    public Method concreteMethodByName(String name, String signature) {
        this.checkPrepared();
        List methods = this.visibleMethods();
        Method method = null;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method candidate = (Method)iter.next();
            if (!candidate.name().equals(name) || !candidate.signature().equals(signature) || candidate.isAbstract()) continue;
            method = candidate;
            break;
        }
        return method;
    }

    List getAllMethods() {
        ArrayList<Method> list = new ArrayList<Method>(this.methods());
        for (ClassType clazz = this.superclass(); clazz != null; clazz = clazz.superclass()) {
            list.addAll(clazz.methods());
        }
        Iterator iter = this.allInterfaces().iterator();
        while (iter.hasNext()) {
            InterfaceType interfaze = (InterfaceType)iter.next();
            list.addAll(interfaze.methods());
        }
        return list;
    }

    List inheritedTypes() {
        ArrayList<ClassType> inherited = new ArrayList<ClassType>(this.interfaces());
        if (this.superclass() != null) {
            inherited.add(0, this.superclass());
        }
        return inherited;
    }

    public boolean isEnum() {
        ClassTypeImpl superclass = (ClassTypeImpl)this.superclass();
        if (superclass != null) {
            return superclass.typeNameAsSymbol().equals(this.vm.javaLangEnum());
        }
        return false;
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.vm.throwNotReadOnlyException("ClassType.setValue(...)");
    }

    public Value invokeMethod(ThreadReference threadIntf, Method methodIntf, List arguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.vm.throwNotReadOnlyException("ClassType.invokeMethod(...)");
        return null;
    }

    public ObjectReference newInstance(ThreadReference threadIntf, Method methodIntf, List arguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.vm.throwNotReadOnlyException("ClassType.newInstance(...)");
        return null;
    }

    void addVisibleMethods(Map methodMap) {
        Iterator iter = this.interfaces().iterator();
        while (iter.hasNext()) {
            InterfaceTypeImpl interfaze = (InterfaceTypeImpl)iter.next();
            interfaze.addVisibleMethods(methodMap);
        }
        ClassTypeImpl clazz = (ClassTypeImpl)this.superclass();
        if (clazz != null) {
            clazz.addVisibleMethods(methodMap);
        }
        this.addToMethodMap(methodMap, this.methods());
    }

    boolean isAssignableTo(ReferenceType type) {
        ClassTypeImpl superclazz = (ClassTypeImpl)this.superclass();
        if (this.equals(type)) {
            return true;
        }
        if (superclazz != null && superclazz.isAssignableTo(type)) {
            return true;
        }
        List interfaces = this.interfaces();
        Iterator iter = interfaces.iterator();
        while (iter.hasNext()) {
            InterfaceTypeImpl interfaze = (InterfaceTypeImpl)iter.next();
            if (!interfaze.isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "class " + this.name() + "(" + this.loaderString() + ")";
    }
}

