/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.MemberFunctionType;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicFunctionType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicMemberFunctionType
extends BasicFunctionType
implements MemberFunctionType {
    private Type containingClass;
    private Type thisType;
    private long thisAdjust;

    public BasicMemberFunctionType(String name, int size, Type returnType, Type containingClass, Type thisType, long thisAdjust) {
        this(name, size, returnType, containingClass, thisType, thisAdjust, 0);
    }

    private BasicMemberFunctionType(String name, int size, Type returnType, Type containingClass, Type thisType, long thisAdjust, int cvAttributes) {
        super(name, size, returnType, cvAttributes);
        this.containingClass = containingClass;
        this.thisType = thisType;
        this.thisAdjust = thisAdjust;
    }

    public MemberFunctionType asMemberFunction() {
        return this;
    }

    public Type getContainingClass() {
        return this.containingClass;
    }

    public Type getThisType() {
        return this.thisType;
    }

    public long getThisAdjust() {
        return this.thisAdjust;
    }

    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        this.containingClass = db.resolveType(this, this.containingClass, listener, "resolving member function class");
        this.thisType = db.resolveType(this, this.thisType, listener, "resolving member function \"this\" type");
        return this;
    }

    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
    }

    protected Type createCVVariant(int cvAttributes) {
        return new BasicMemberFunctionType(this.getName(), this.getSize(), this.getReturnType(), this.getContainingClass(), this.getThisType(), this.getThisAdjust(), cvAttributes);
    }

    public void visit(TypeVisitor v) {
        v.doMemberFunctionType(this);
    }
}

