/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.awt.DebugHelper;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.GetPropertyAction;

public class Cursor
implements Serializable {
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    protected static Cursor[] predefined = new Cursor[14];
    static final String[][] cursorProperties = new String[][]{{"AWT.DefaultCursor", "Default Cursor"}, {"AWT.CrosshairCursor", "Crosshair Cursor"}, {"AWT.TextCursor", "Text Cursor"}, {"AWT.WaitCursor", "Wait Cursor"}, {"AWT.SWResizeCursor", "Southwest Resize Cursor"}, {"AWT.SEResizeCursor", "Southeast Resize Cursor"}, {"AWT.NWResizeCursor", "Northwest Resize Cursor"}, {"AWT.NEResizeCursor", "Northeast Resize Cursor"}, {"AWT.NResizeCursor", "North Resize Cursor"}, {"AWT.SResizeCursor", "South Resize Cursor"}, {"AWT.WResizeCursor", "West Resize Cursor"}, {"AWT.EResizeCursor", "East Resize Cursor"}, {"AWT.HandCursor", "Hand Cursor"}, {"AWT.MoveCursor", "Move Cursor"}};
    int type = 0;
    public static final int CUSTOM_CURSOR = -1;
    private static final Hashtable systemCustomCursors = new Hashtable(1);
    private static final String systemCustomCursorDirPrefix = Cursor.initCursorDir();
    private static final String systemCustomCursorPropertiesFile = systemCustomCursorDirPrefix + "cursors.properties";
    private static Properties systemCustomCursorProperties = null;
    private static final String CursorDotPrefix = "Cursor.";
    private static final String DotFileSuffix = ".File";
    private static final String DotHotspotSuffix = ".HotSpot";
    private static final String DotNameSuffix = ".Name";
    private static final long serialVersionUID = 8028237497568985504L;
    private static final DebugHelper dbg = DebugHelper.create(Cursor.class);
    private transient long pData;
    private transient Object anchor = new Object();
    transient CursorDisposer disposer;
    protected String name;

    private static String initCursorDir() {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        return string + File.separator + "lib" + File.separator + "images" + File.separator + "cursors" + File.separator;
    }

    private static native void initIDs();

    private void setPData(long l) {
        this.pData = l;
        if (!GraphicsEnvironment.isHeadless() && l != 0L) {
            if (this.disposer == null) {
                if (this.anchor == null) {
                    this.anchor = new Object();
                }
                this.disposer = new CursorDisposer();
                Disposer.addRecord(this.anchor, this.disposer);
            }
            this.disposer.pData = l;
        }
    }

    public static Cursor getPredefinedCursor(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (predefined[n] == null) {
            Cursor.predefined[n] = new Cursor(n);
        }
        return predefined[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cursor getSystemCustomCursor(String string) throws AWTException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        Cursor cursor = (Cursor)systemCustomCursors.get(string);
        if (cursor == null) {
            String string2;
            Object object = systemCustomCursors;
            synchronized (object) {
                if (systemCustomCursorProperties == null) {
                    Cursor.loadSystemCustomCursorProperties();
                }
            }
            object = CursorDotPrefix + string;
            String string3 = (String)object + DotFileSuffix;
            if (!systemCustomCursorProperties.containsKey(string3)) {
                return null;
            }
            final String string4 = systemCustomCursorProperties.getProperty(string3);
            String string5 = systemCustomCursorProperties.getProperty((String)object + DotNameSuffix);
            if (string5 == null) {
                string5 = string;
            }
            if ((string2 = systemCustomCursorProperties.getProperty((String)object + DotHotspotSuffix)) == null) {
                throw new AWTException("no hotspot property defined for cursor: " + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() != 2) {
                throw new AWTException("failed to parse hotspot property for cursor: " + string);
            }
            int n = 0;
            int n2 = 0;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new AWTException("failed to parse hotspot property for cursor: " + string);
            }
            try {
                final int n3 = n;
                final int n4 = n2;
                final String string6 = string5;
                cursor = (Cursor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        Image image = toolkit.getImage(systemCustomCursorDirPrefix + string4);
                        return toolkit.createCustomCursor(image, new Point(n3, n4), string6);
                    }
                });
            }
            catch (Exception exception) {
                throw new AWTException("Exception: " + exception.getClass() + " " + exception.getMessage() + " occurred while creating cursor " + string);
            }
            if (cursor == null) {
            } else {
                systemCustomCursors.put(string, cursor);
            }
        }
        return cursor;
    }

    public static Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public Cursor(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        this.type = n;
        this.name = Toolkit.getProperty(cursorProperties[n][0], cursorProperties[n][1]);
    }

    protected Cursor(String string) {
        this.type = -1;
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSystemCustomCursorProperties() throws AWTException {
        Hashtable hashtable = systemCustomCursors;
        synchronized (hashtable) {
            systemCustomCursorProperties = new Properties();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        FileInputStream fileInputStream = null;
                        try {
                            fileInputStream = new FileInputStream(systemCustomCursorPropertiesFile);
                            systemCustomCursorProperties.load(fileInputStream);
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                systemCustomCursorProperties = null;
                throw new AWTException("Exception: " + exception.getClass() + " " + exception.getMessage() + " occurred while loading: " + systemCustomCursorPropertiesFile);
            }
        }
    }

    private static native void finalizeImpl(long var0);

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Cursor.initIDs();
        }
    }

    static class CursorDisposer
    implements DisposerRecord {
        long pData;

        CursorDisposer() {
        }

        public void dispose() {
            Cursor.finalizeImpl(this.pData);
        }
    }
}

