/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior;

import com.sun.corba.se.impl.ior.ByteBuffer;
import com.sun.corba.se.impl.ior.ObjectAdapterIdArray;
import com.sun.corba.se.impl.logging.IORSystemException;
import com.sun.corba.se.spi.ior.ObjectAdapterId;
import com.sun.corba.se.spi.ior.ObjectId;
import com.sun.corba.se.spi.ior.ObjectKeyTemplate;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersion;
import com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
import java.util.Iterator;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class ObjectKeyTemplateBase
implements ObjectKeyTemplate {
    public static final String JIDL_ORB_ID = "";
    private static final String[] JIDL_OAID_STRINGS = new String[]{"TransientObjectAdapter"};
    public static final ObjectAdapterId JIDL_OAID = new ObjectAdapterIdArray(JIDL_OAID_STRINGS);
    private ORB orb;
    protected IORSystemException wrapper;
    private ORBVersion version;
    private int magic;
    private int scid;
    private int serverid;
    private String orbid;
    private ObjectAdapterId oaid;
    private byte[] adapterId;

    public byte[] getAdapterId() {
        return (byte[])this.adapterId.clone();
    }

    private byte[] computeAdapterId() {
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.append(this.getServerId());
        byteBuffer.append(this.orbid);
        byteBuffer.append(this.oaid.getNumLevels());
        Iterator iterator = this.oaid.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            byteBuffer.append(string);
        }
        byteBuffer.trimToSize();
        return byteBuffer.toArray();
    }

    public ObjectKeyTemplateBase(ORB oRB, int n, int n2, int n3, String string, ObjectAdapterId objectAdapterId) {
        this.orb = oRB;
        this.wrapper = IORSystemException.get(oRB, "oa.ior");
        this.magic = n;
        this.scid = n2;
        this.serverid = n3;
        this.orbid = string;
        this.oaid = objectAdapterId;
        this.adapterId = this.computeAdapterId();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectKeyTemplateBase)) {
            return false;
        }
        ObjectKeyTemplateBase objectKeyTemplateBase = (ObjectKeyTemplateBase)object;
        return this.magic == objectKeyTemplateBase.magic && this.scid == objectKeyTemplateBase.scid && this.serverid == objectKeyTemplateBase.serverid && this.version.equals(objectKeyTemplateBase.version) && this.orbid.equals(objectKeyTemplateBase.orbid) && this.oaid.equals(objectKeyTemplateBase.oaid);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.magic;
        n = 37 * n + this.scid;
        n = 37 * n + this.serverid;
        n = 37 * n + this.version.hashCode();
        n = 37 * n + this.orbid.hashCode();
        n = 37 * n + this.oaid.hashCode();
        return n;
    }

    public int getSubcontractId() {
        return this.scid;
    }

    public int getServerId() {
        return this.serverid;
    }

    public String getORBId() {
        return this.orbid;
    }

    public ObjectAdapterId getObjectAdapterId() {
        return this.oaid;
    }

    public void write(ObjectId objectId, OutputStream outputStream) {
        this.writeTemplate(outputStream);
        objectId.write(outputStream);
    }

    public void write(OutputStream outputStream) {
        this.writeTemplate(outputStream);
    }

    protected abstract void writeTemplate(OutputStream var1);

    protected int getMagic() {
        return this.magic;
    }

    public void setORBVersion(ORBVersion oRBVersion) {
        this.version = oRBVersion;
    }

    public ORBVersion getORBVersion() {
        return this.version;
    }

    protected byte[] readObjectKey(InputStream inputStream) {
        int n = inputStream.read_long();
        byte[] byArray = new byte[n];
        inputStream.read_octet_array(byArray, 0, n);
        return byArray;
    }

    public CorbaServerRequestDispatcher getServerRequestDispatcher(ORB oRB, ObjectId objectId) {
        return oRB.getRequestDispatcherRegistry().getServerRequestDispatcher(this.scid);
    }
}

