.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
glschool - a 3D schooling simulation
.SH SYNOPSIS
.B glschool
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-wireframe]
[\-fps]
[\-delay \fInumber\fP]
[\-nfish \fInumber\fP]
[\-maxvel \fInumber\fP]
[\-minvel \fInumber\fP]
[\-acclimit \fInumber\fP]
[\-avoidfact \fInumber\fP]
[\-matchfact \fInumber\fP]
[\-centerfact \fInumber\fP]
[\-targetfact \fInumber\fP]
[\-minradius \fInumber\fP]
[\-momentum \fInumber\fP]
[\-distexp \fInumber\fP]
[\-goalchgf \fInumber\fP]
[\-fog]
[\-drawgoal]
[\-drawbbox]
.SH DESCRIPTION
Uses Craig Reynolds Boids algorithm to simulate a 3d school of
fish.  See <http://www.red3d.com/cwr/boids> for a description
of the algorithm and the original paper.  This is a lightly modified
version of the algorithm that supports goal attraction.

Many different behaviors are possible by tweaking the parameters.  No sanity checking is performed
on the command line params, so if you want to use negative accelerations or minimum velocity that is
larger than maximum velocity or that sort of thing, the simulation will try to digest it.

It looks best with the highest number of fish that will give you an FPS of > 25 or so.

.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 20000 (0.020 seconds.).
.TP 8
.B \-wireframe | \-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.TP 8
.B \-fog | \-no-fog
 Whether to show foggy (cloudy) water.
.TP 8
.B \-drawgoal | \-no-drawgoal
 Whether to show the school's attraction goal.
.TP 8
.B \-drawbbox | \-no-drawbbox
 Whether to show the bounding box.
.TP 8
.B \-fog | \-no-fog
 Whether to show foggy (cloudy) water.
.TP 8
.B \-nfish \fInumber\fP
Number of fish.  Defaults to 100
.TP 8
.B \-acclimit \fInumber\fP
Acceleration limit.  Defaults to 8.0
.TP 8
.B \-minvel \fInumber\fP
Minimum velocity.  Defaults to 1.0
.TP 8
.B \-maxvel \fInumber\fP
Minimum velocity.  Defaults to 7.0
.TP 8
.B \-goalchgf \fInumber\fP
Goal change frequency.  Defaults to 50 (frames)
.TP 8
.B \-avoidfact \fInumber\fP
Avoidance acceleration factor.  Defaults to 1.5
.TP 8
.B \-matchfact \fInumber\fP
Match avg velocity acceleration factor.  Defaults to 0.15
.TP 8
.B \-centerfact \fInumber\fP
School centering acceleration factor.  Defaults to 0.1
.TP 8
.B \-targetfact \fInumber\fP
Target attraction acceleration factor.  Defaults to 80
.TP 8
.B \-distexp \fInumber\fP
Distance weighting exponent.  Defaults to 2.2
.TP 8
.B \-momentum \fInumber\fP
Momentum.  Defaults to 0.9
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2005-2006 by David C. Lambert.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
David C. Lambert
