.\" -*- coding: us-ascii -*-
.TH xlsfonts __appmansuffix__ "25 October 2004"  
.SH NAME
xlsfonts \- server font list displayer for X
.SH SYNOPSIS
.ad l
\fBxlsfonts\fR \kx
.if (\nxu > (\n(.lu / 2)) .nr x (\n(.lu / 5)
'in \n(.iu+\nxu
[\fB\-display \fBhost:dpy\fR\fR] [\fB\-l\fR] [\fB\-ll\fR] [\fB\-lll\fR] [\fB\-m\fR] [\fB\-C\fR] [\fB\-1\fR] [\fB\-w \fBwidth\fR\fR] [\fB\-n \fBcolumns\fR\fR] [\fB\-u\fR] [\fB\-o\fR] [\fB\-fn \fBpattern\fR\fR]
'in \n(.iu-\nxu
.ad b
.PP
.ad l
\fBxlsfonts\fR \kx
.if (\nxu > (\n(.lu / 2)) .nr x (\n(.lu / 5)
'in \n(.iu+\nxu
\fB\-printer \fBprintername\fR\fR [\fB\-l\fR] [\fB\-ll\fR] [\fB\-lll\fR] [\fB\-m\fR] [\fB\-C\fR] [\fB\-1\fR] [\fB\-w \fBwidth\fR\fR] [\fB\-n \fBcolumns\fR\fR] [\fB\-u\fR] [\fB\-o\fR] [\fB\-r \fBresolution\fR\fR] [\fB\-b\fR] [\fB\-B\fR] [\fB\-g\fR] [\fB\-G\fR] [\fB\-x \fBmode\fR\fR] [\fB\-X \fBmode\fR\fR] [\fB\-fn \fBpattern\fR\fR]
'in \n(.iu-\nxu
.ad b
.SH DESCRIPTION
xlsfonts lists the fonts that match the given pattern.
The wildcard character "*" may be used to match any sequence of characters
(including none), and "?" to match any single character.
If no pattern is given, "*" is assumed.
.PP
The "*" and "?" characters must be quoted to prevent them from being expanded by the shell.
.SH OPTIONS
.TP 
\fB\-display \fIhost:dpy\fB\fR 
This option specifies the X server to contact.
.TP 
\fB\-printer \fIprintername\fB\fR 
This option specifies the Xprint printer to contact.
.TP 
\fB\-d \fIhost:dpy\fB\fR 
Same as \fB\-display \fIhost:dpy\fB\fR.
.TP 
\fB\-p \fIprintername\fB\fR 
Same as \fB\-printer \fIprintername\fB\fR.
.TP 
\fB\-l\fR 
Lists some attributes of the font on one line in addition
to its name.
.TP 
\fB\-ll\fR 
Lists font properties in addition to \fB\-l\fR output.
.TP 
\fB\-lll\fR 
Lists character metrics in addition to \fB\-ll\fR output.
.TP 
\fB\-m\fR 
This option indicates that long listings should also print
the minimum and maximum bounds of each font.
.TP 
\fB\-C\fR 
This option indicates that listings should use multiple columns.
This is the same as \fB\-n 0\fR.
.TP 
\fB\-1\fR 
This option indicates that listings should use a single column.
This is the same as \fB\-n 1\fR.
.TP 
\fB\-w \fIwidth\fB\fR 
This option specifies the width in characters that should be
used in figuring out how many columns to print.
The default is 79.
.TP 
\fB\-n \fIcolumns\fB\fR 
This option specifies the number of columns to use in
displaying the output. By default, it will attempt to
fit as many columns of font names into the number of
character specified by \fB\-w\fR width.
.TP 
\fB\-u\fR 
This option indicates that the output should be left unsorted.
.TP 
\fB\-o\fR 
This option indicates that xlsfonts should do an OpenFont
(and QueryFont, if appropriate) rather than a ListFonts.
This is useful if ListFonts or ListFontsWithInfo fail to
list a known font (as is the case with some scaled font
systems).
.TP 
\fB\-r \fIresolutionname\fB\fR 
Set print resolution name (usually values like \fB300dpi\fR
or \fB300x600\fR, see output of xplsprinters).
This may alter the output of xlsfonts if there are printer
fonts which get enabled/disabled on per-resolution basis by the DDX.

(printer mode only)
.TP 
\fB\-b\fR 
List printer builtin fonts.
This is the same as \fB\-x xp\-list\-internal\-printer\-fonts\fR.

(printer mode only)
.TP 
\fB\-B\fR 
Do not list printer builtin fonts.
This is the same as \fB\-X xp\-list\-internal\-printer\-fonts\fR.

(printer mode only)
.TP 
\fB\-g\fR 
List glyph fonts.
This is the same as \fB\-x xp\-list\-glyph\-fonts\fR.

(printer mode only)
.TP 
\fB\-G\fR 
Do not list glyph fonts.
This is the same as \fB\-X xp\-list\-glyph\-fonts\fR.

(printer mode only)
.TP 
\fB\-x \fImode\fB\fR 
Enable listfont mode \fImode\fR.

Supported modes are:
.RS 
.TP 
xp-listinternal-printer-fonts
If \fBxp\-listinternal\-printer\-fonts\fR was set
(via option \fB\-b\fR or
\fB\-x xp\-listinternal\-printer\-fonts\fR xlsfonts
will include all of the fonts defined as internal printer fonts.
.TP 
xp-list-glyph-fonts
If \fBxp\-list\-glyph\-fonts\fR was set (via option \fB\-g\fR or
\fB\-x xp\-list\-glyph\-fonts\fR) xlsfonts will
include all of the fonts available to the server which have
glyphs associated with them.
.RE


The default value is implicitly determined by the ddx driver to be the
all of the listfonts modes specified in the \fBxp\-listfonts\-modes\-supported\fR
printer attribute.


The value of \fBxp\-listfonts\-modes\-supported\fR and
\fBxp\-listfonts\-modes\fR (the defaults) can be looked-up via
\fBxplsprinters\fR(__appmansuffix__).


(printer mode only)
.TP 
\fB\-X \fImode\fB\fR 
Disable listfont mode \fImode\fR.
See option \fB\-x\fR for a list of valid
\fImode\fR values.

(printer mode only)
.TP 
\fB\-fn \fIpattern\fB\fR 
This option specifies the font name pattern to match.
.SH "SEE ALSO"
\fBX\fR(__miscmansuffix__), \fBXprint\fR(__miscmansuffix__), \fBXserver\fR(__appmansuffix__), \fBxset\fR(__appmansuffix__), \fBxfd\fR(__appmansuffix__), \fBxplsprinters\fR(__appmansuffix__), X Logical Font Description Conventions
.SH ENVIRONMENT
.TP 
\fBDISPLAY\fR 
\fBDISPLAY\fR must be set to get the default host and display to use.
.TP 
\fBXPSERVERLIST\fR 
\fBXPSERVERLIST\fR must be set for the \fB\-printer\fR option
identifying the available Xprint servers.
See \fBXprint\fR(__miscmansuffix__)
for more details.
.SH BUGS
Doing ``xlsfonts -l'' can tie up your server for a very long time. 
This is really a bug with single-threaded
non-preemptable servers, not with this program.
.SH AUTHOR

Mark Lillibridge
.PP
Jim Fulton
.PP
Phil Karlton
.PP
Roland Mainz

