<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann <marco.ladermann@gmx.de>
  ** Date:   Tue Jan 28 17:19:16 CET 2003 @721 /Internet Time/
  ** 
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:kde="http://kde.org/functions"
    xmlns:java="http://kde.org/java"

 >
    <!--
      ** putStringProperty
      ** TODO: Use data to distinguish constructor generation from languageChange
      ** @context string
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putStringProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="text" select="."/>
        <xsl:variable name="quotedtext" select="java:toJavaString($text)"/>
        <xsl:variable name="val">
            <xsl:value-of select="java:tr(kde:isUtf8($text))"/>
            <xsl:text>( &quot;</xsl:text>
            <xsl:value-of select="$quotedtext"/>
            <xsl:if test="../comment">
                <xsl:text>&quot;, &quot;</xsl:text>
                <xsl:value-of select="../comment"/>
            </xsl:if>
            <xsl:text>&quot; )</xsl:text>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$property = 'toolTip' and name(../..) != 'action'">
                <xsl:value-of select="concat('QToolTip.add( ', $object, ', ', $val, ' );')"/>
            </xsl:when>
            <xsl:when test="$property = 'whatsThis' and name(../..) != 'action'">
                <xsl:value-of select="concat('QWhatsThis.add( ', $object, ', ', $val, ' );')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
                <xsl:variable name="parameter">
                    <xsl:choose>
                        <xsl:when test="$property = 'accel'">
                            <xsl:value-of select="concat('new QKeySequence( ', $val, ' ) ')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$val"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:value-of select="concat($object, '.', $method, '( ', $parameter, ' );')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!--
      ** putStringlistProperty
      ** @context stringlist
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putStringlistProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:if test="$property != 'database'"><!-- database must be handled in "putMethods" -->
            <xsl:variable name="object" select="java:getNodeName(../..)"/>
            <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
            <xsl:value-of select="$nlIndent8"/>
            <xsl:value-of select="concat($object, '.', $method)"/>
            <xsl:text>(new String[] { </xsl:text>
            <xsl:for-each select="string">
                <xsl:if test="position() &gt; 1">
                    <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="concat('&quot;',java:toJavaString(.) ,'&quot;')"/>
            </xsl:for-each>
            <xsl:text>});</xsl:text>
        </xsl:if>
    </xsl:template>

    <!--
      ** putCstringProperty
      ** @context cstring
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putCstringProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method, '( ', ., ' );')"/>
    </xsl:template>


    <!--
      ** putBoolProperty
      ** @context bool 1|0  but i have seen also "true" and "false"
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putBoolProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <!-- the frameworkCode property is an "generation" time property -->
        <xsl:if test="$property != 'frameworkCode'">
            <xsl:variable name="object" select="java:getNodeName(../..)"/>
            <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
            <xsl:variable name="bool" select="string(. = 1 or . = 'true')"/>
            <xsl:value-of select="$nlIndent8"/>
            <xsl:value-of select="concat($object, '.', $method, '( ', $bool, ' );')"/>
        </xsl:if>
    </xsl:template>

    <!--
      ** putColorProperty
      ** @context color (green, red, blue)
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putColorProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method, '( new QColor( ', green, ', ',
                                                                              red,  ', ',
                                                                              blue,' ) );')"/>
    </xsl:template>

    <!--
      ** putCursorProperty
      ** @context cursor 
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putCursorProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method, '( new QCursor(', ., ') );')"/>
    </xsl:template>


    <!--
      ** putNumberProperty
      ** @context number 
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putNumberProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="arg">
            <xsl:choose>
                <xsl:when test="$property = 'accel'">
                    <xsl:value-of select="concat('new QKeySequence( ', ., ' )')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="."/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method, '( ', $arg, ' );')"/>
    </xsl:template>

    <!--
      ** putEnumProperty
      ** @context enum
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putEnumProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="enumClass">
            <xsl:apply-templates select="../.." mode="toClass"/>
            <xsl:text>.</xsl:text>
        </xsl:variable>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method, '( ', $enumClass, ., ' );')"/>
    </xsl:template>

    <!--
      ** putSetProperty
      ** @context set
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putSetProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="setClass">
            <xsl:apply-templates select="../.." mode="toClass"/>
            <xsl:text>.</xsl:text>
        </xsl:variable>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method, '( ', $setClass, 
                                                                  kde:replace(., 
																  			  '|', 
																			  concat('|', $setClass)), 
                                                                  ' );')"/>
    </xsl:template>

    <!--
      ** putPixmapProperty
      ** @context pixmap
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putPixmapProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.'
                                    , $method, 
                                    '( QPixmap.fromMimeSource( &quot;', . , '&quot; ) );')"/>
    </xsl:template>

    <!--
      ** putPointProperty
      ** @context point (x, y)
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putPointProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method,
                                    '( new QPoint( ', kde:if(x, x, 0), ', ', kde:if(y, y, 0), ' ) );')"/>
    </xsl:template>

    <!--
      ** putRectProperty
      ** @context rect (x, y, width, height)
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putRectProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method,
                                    '( new QRect( ', kde:if(x, x, 0), ', '
                                                   , kde:if(y, y, 0), ', '
                                                   , kde:if(width, width, 0), ', '
                                                   , kde:if(height, height, 0), 
                                              ' ) );')"/>
    </xsl:template>

    <!--
      ** putSizeProperty
      ** @context size (width, height)
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putSizeProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method,
                                    '( new QSize( ', kde:if(width, width, 0), ', '
                                                   , kde:if(heigth, heigth, 0), 
                                              ' ) );')"/>
    </xsl:template>

    <!--
      ** putSizepolicyProperty
      ** @context sizepolicy (hsizetype, vsizetype, horstretch, verstretch)
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putSizepolicyProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method,
                                    '( new QSizePolicy( ', hsizetype, ', '
                                                         , vsizetype, ', '
                                                         , '(short)', horstretch, ', '
                                                         , '(short)', verstretch, 
                                                    ' ) );')"/>
    </xsl:template>

    <!--
      ** putFontProperty
      ** @context font (family, pointsize, weight, underline, strikeout)
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putFontProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method,
                                    '( new QFont( &quot;', family, '&quot;, '
                                                , kde:if(pointsize, pointsize, 10), ', '
                                                , kde:if(weight, weight, 'QFont.Normal'),
                                              ' ) );')"/>
    </xsl:template>


    <!--
      ** putPaletteProperty
      ** @context palette (color){1, 15}
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putPaletteProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        <xsl:variable name="object" select="java:getNodeName(../..)"/>
        <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
        <xsl:variable name="pal" select="concat($object, 'Palette')"/>
        <xsl:variable name="cgroup" select="concat($object, 'ColorGroup')"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="'// setup a modified palette'"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat('QPalette ', $pal, ' = new QPalette();')"/>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat('QColorGroup ', $cgroup, ' = new QColorGroup();')"/>
        <xsl:for-each select="active|disabled|inactive">
            <xsl:for-each select="color">
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="concat($cgroup, 
                                             '.setColor( ', position() - 1, 
                                             ', new QColor( ',
                                                            red, ', ',
                                                            green, ', ',
                                                            blue, '));')"/>
            </xsl:for-each>
            <xsl:value-of select="$nlIndent8"/>
            <xsl:value-of select="concat($pal, '.set', kde:upper-first(name()),'( ',$cgroup, ' );')"/>
        </xsl:for-each>
        <xsl:value-of select="$nlIndent8"/>
        <xsl:value-of select="concat($object, '.', $method, '( ', $pal, ' );')"/>
    </xsl:template>

    <!--
      ** putIconsetProperty
      ** @context iconset 
      ** @param property is the name of the property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putIconsetProperty">
        <xsl:param name="property"/>
        <xsl:param name="data"/>
        
        <xsl:if test=". != ''">
            <xsl:variable name="object" select="java:getNodeName(../..)"/>
            <xsl:variable name="method" select="concat('set', kde:upper-first($property))"/>
            <xsl:value-of select="$nlIndent8"/>
            <xsl:value-of select="concat($object, '.', $method,
                                        '( new QIconSet( ', java:getPixmap(.), ' ) );')"/>
        </xsl:if>                                                  
    </xsl:template>

</xsl:stylesheet>

