/*  
 *  xcall - Packet radio program for GTK+
 *  Copyright (C) 2001 Joop Stakenborg <pa4tu@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/* utils.c - private functions that don't belong in other modules */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "utils.h"
#include "support.h"
#include "interface.h"
#include "types.h"

extern GtkWidget *window1, *preferencesdialog;
extern GdkColor yellow, white, red, green;
extern preferencestype preferences;
extern gint buttonnumber;
extern gboolean recording;
extern GList *recordhistory, *connecthistory;
gint combotype = -1;

/* set title of a dialog */
void set_title(GtkWidget *dialog, gchar *format)
{
  GString *title = g_string_new("");

  g_string_sprintf(title, format, PACKAGE);
  gtk_window_set_title (GTK_WINDOW(dialog), title->str);
  g_string_free(title, TRUE);
}

/* write text to the main text window */
void write_text (gchar *msg, gint type) {
  GtkWidget *maintext;
  GdkFont *textfont;
  
  maintext = lookup_widget(window1, "text1");
  textfont = gdk_font_load(preferences.font->str);

  switch(type) {
    case RXMESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.rxfgcolor, NULL, msg, -1);
      break;
    case TXMESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.txfgcolor, NULL, msg, -1);
      break;
    case STATUSMESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.statusfgcolor, NULL, msg, -1);
      break;
    case ERRORMESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.errorfgcolor, NULL, msg, -1);
      break;
    case DX1_8MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx1_8color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX3_5MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx3_5color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX7MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx7color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX10MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx10color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX14MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx14color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX18MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx18color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX21MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx21color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX24MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx24color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DX28MESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dx28color, &preferences.dxbackgroundcolor, msg, -1);
      break;
    case DXOTHERMESSAGE:
      gtk_text_insert(GTK_TEXT(maintext), textfont, &preferences.dxothercolor, &preferences.dxbackgroundcolor, msg, -1);
      break;
  }
}

void writemessage(gchar *firststring, gchar *secondstring, gint messagetype) {
  GString *msgbuf = g_string_new("");

  if (secondstring == NULL) 
    (void *)g_string_append(msgbuf, firststring);
  else  /* firststring is a C-format string */
    g_string_sprintf(msgbuf, firststring, secondstring);
  write_text(msgbuf->str, messagetype);
  g_string_free(msgbuf, TRUE);
}

/* simple dialog with title, label and OK button */
void showdialog(GString *label, gchar *title) {
  GtkWidget *dialog, *dialoglabel;

  dialog = create_dialog1();
  dialoglabel = lookup_widget(dialog, "label1");
  gtk_label_set_text(GTK_LABEL(dialoglabel), label->str);
  set_title(dialog, title);
  gtk_widget_grab_focus(dialog);
  gtk_widget_show(dialog);
}

/*combodialog with title, label, combobox, Cancel and OK button */
void showcombodialog(GString *label, gchar *title) {
  GtkWidget *combodialog, *combolabel, *combobox;

  combodialog = create_dialog3();
  combolabel = lookup_widget(combodialog, "label29");
  combobox = lookup_widget(combodialog, "combo2");
  set_title(combodialog, title);
  gtk_label_set_text(GTK_LABEL(combolabel), label->str);

  if (combotype == RECORDOFF)
    gtk_widget_hide(combobox);
  else if (combotype == RECORDON && recordhistory)
    (gtk_combo_set_popdown_strings(GTK_COMBO(combobox), recordhistory));
  else if (combotype == CONNECT && connecthistory)
    (gtk_combo_set_popdown_strings(GTK_COMBO(combobox), connecthistory));
  else if (combotype == KILL)
    gtk_widget_hide(combobox);
  else if (combotype == DISCONNECT)
    gtk_widget_hide(combobox);

  gtk_widget_grab_focus(combodialog);
  gtk_widget_set_sensitive(window1, 0);
  gtk_widget_show(combodialog);
}

/* set new color style of a button in the preferences dialog */
void setbuttoncolor(gchar *buttonname, GdkColor buttoncolor)
{
  GtkWidget *colorbutton;
  GtkStyle *buttonstyle;
  
  colorbutton = lookup_widget(preferencesdialog, buttonname);
  buttonstyle = gtk_style_new();
  buttonstyle->bg[GTK_STATE_NORMAL] = buttoncolor;
  buttonstyle->bg[GTK_STATE_ACTIVE] = buttoncolor;
  buttonstyle->bg[GTK_STATE_PRELIGHT] = buttoncolor;
  buttonstyle->bg[GTK_STATE_SELECTED] = buttoncolor;
  gtk_widget_set_style(colorbutton, buttonstyle);
}

/* lookup which button in preferences dialog should get a new color */
void updatebuttoncolor(GdkColor selectedcolor) {

  switch (buttonnumber)
  {
    case 1:
      preferences.statusfgcolor = selectedcolor;
      setbuttoncolor("button5", selectedcolor);
    break;
    case 2:
      preferences.errorfgcolor = selectedcolor;
      setbuttoncolor("button6", selectedcolor);
    break;
    case 3:
      preferences.rxfgcolor = selectedcolor;
      setbuttoncolor("button7", selectedcolor);
    break;
    case 4:
      preferences.txfgcolor = selectedcolor;
      setbuttoncolor("button8", selectedcolor);
    break;
    case 5:
      preferences.backgroundcolor = selectedcolor;
      setbuttoncolor("button9", selectedcolor);
    break;
    case 101:
      preferences.dxbackgroundcolor = selectedcolor;
      setbuttoncolor("dxbgbutton", selectedcolor);
    break;
    case 102:
      preferences.dx1_8color = selectedcolor;
      setbuttoncolor("dx1_8button", selectedcolor);
    break;
    case 103:
      preferences.dx3_5color = selectedcolor;
      setbuttoncolor("dx3_5button", selectedcolor);
    break;
    case 104:
      preferences.dx7color = selectedcolor;
      setbuttoncolor("dx7button", selectedcolor);
    break;
    case 105:
      preferences.dx10color = selectedcolor;
      setbuttoncolor("dx10button", selectedcolor);
    break;
    case 106:
      preferences.dx14color = selectedcolor;
      setbuttoncolor("dx14button", selectedcolor);
    break;
    case 107:
      preferences.dx18color = selectedcolor;
      setbuttoncolor("dx18button", selectedcolor);
    break;
    case 108:
      preferences.dx21color = selectedcolor;
      setbuttoncolor("dx21button", selectedcolor);
    break;
    case 109:
      preferences.dx24color = selectedcolor;
      setbuttoncolor("dx24button", selectedcolor);
    break;
    case 110:
      preferences.dx28color = selectedcolor;
      setbuttoncolor("dx28button", selectedcolor);
    break;
    case 111:
      preferences.dxothercolor = selectedcolor;
      setbuttoncolor("dxotherbutton", selectedcolor);
    break;
    default:
    break;
  }
}


/* Convert color to right format for XParseColor, so it can be processed by gdk_color_parse */
gchar *color_parse(gchar value[100])
{
  gchar **valuesplit = NULL;
  gchar *rgbsyntax;
  
  valuesplit = g_strsplit(value, ",", 3);
  rgbsyntax = g_strconcat("rgb:", valuesplit[0], "/", valuesplit[1], "/", valuesplit[2], NULL);
  g_strfreev(valuesplit);
  return (rgbsyntax);
}


/* lookup a widget and set visible or invisible, depending on 'state' */
void widget_visible(gchar *name, gboolean state) {
  GtkWidget *widget;
  
  widget = lookup_widget(window1, name);
  if (state) gtk_widget_show(widget); else gtk_widget_hide(widget);
}
