/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class FullThreadDump {
    private MBeanServerConnection server;
    private JMXConnector jmxc;

    public FullThreadDump(String string, int n) {
        System.out.println("Connecting to " + string + ":" + n);
        String string2 = "/jndi/rmi://" + string + ":" + n + "/jmxrmi";
        this.connect(string2);
    }

    public void dump() {
        try {
            ThreadMonitor threadMonitor = new ThreadMonitor(this.server);
            threadMonitor.dumpThreadInfo();
            if (!threadMonitor.findDeadlock()) {
                System.out.println("No deadlock found.");
            }
        }
        catch (IOException iOException) {
            System.err.println("\nCommunication error: " + iOException.getMessage());
            System.exit(1);
        }
    }

    private void connect(String string) {
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", "", 0, string);
            this.jmxc = JMXConnectorFactory.connect(jMXServiceURL);
            this.server = this.jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            System.err.println("\nCommunication error: " + iOException.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length != 1) {
            FullThreadDump.usage();
        }
        if ((stringArray2 = stringArray[0].split(":")).length != 2) {
            FullThreadDump.usage();
        }
        String string = stringArray2[0];
        int n = -1;
        try {
            n = Integer.parseInt(stringArray2[1]);
        }
        catch (NumberFormatException numberFormatException) {
            FullThreadDump.usage();
        }
        if (n < 0) {
            FullThreadDump.usage();
        }
        FullThreadDump fullThreadDump = new FullThreadDump(string, n);
        fullThreadDump.dump();
    }

    private static void usage() {
        System.out.println("Usage: java FullThreadDump <hostname>:<port>");
    }
}

