/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.pkcs11.P11DHKeyFactory;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11KeyAgreement
extends KeyAgreementSpi {
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private P11Key privateKey;
    private BigInteger publicValue;
    private int secretLen;
    private KeyAgreement multiPartyAgreement;

    P11KeyAgreement(Token token, String string, long l) {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = P11KeyFactory.convertKey(this.token, key, this.algorithm);
        this.publicValue = null;
        this.multiPartyAgreement = null;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, secureRandom);
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        BigInteger bigInteger3;
        Object object2;
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicValue != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (this.multiPartyAgreement != null || !bl) {
            if (this.multiPartyAgreement == null) {
                try {
                    this.multiPartyAgreement = KeyAgreement.getInstance("DH", P11Util.getSunJceProvider());
                    this.multiPartyAgreement.init(this.privateKey);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidKeyException("Could not initialize multi party agreement", noSuchAlgorithmException);
                }
            }
            return this.multiPartyAgreement.doPhase(key, bl);
        }
        if (!(key instanceof PublicKey) || !key.getAlgorithm().equals(this.algorithm)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm DH");
        }
        if (key instanceof DHPublicKey) {
            object2 = (DHPublicKey)key;
            bigInteger3 = object2.getY();
            object = object2.getParams();
            bigInteger2 = ((DHParameterSpec)object).getP();
            bigInteger = ((DHParameterSpec)object).getG();
        } else {
            object2 = new P11DHKeyFactory(this.token, "DH");
            try {
                object = ((P11KeyFactory)object2).engineGetKeySpec(key, DHPublicKeySpec.class);
                bigInteger3 = ((DHPublicKeySpec)object).getY();
                bigInteger2 = ((DHPublicKeySpec)object).getP();
                bigInteger = ((DHPublicKeySpec)object).getG();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("Could not obtain key values", invalidKeySpecException);
            }
        }
        if (!(!(this.privateKey instanceof DHPrivateKey) || bigInteger2.equals(((DHParameterSpec)(object = (object2 = (DHPrivateKey)((Object)this.privateKey)).getParams())).getP()) && bigInteger.equals(((DHParameterSpec)object).getG()))) {
            throw new InvalidKeyException("PublicKey DH parameters must match PrivateKey DH parameters");
        }
        this.publicValue = bigInteger3;
        this.secretLen = bigInteger2.bitLength() + 7 >> 3;
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.multiPartyAgreement != null) {
            byte[] byArray = this.multiPartyAgreement.generateSecret();
            this.multiPartyAgreement = null;
            return byArray;
        }
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, 16L)};
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, 16L, cK_ATTRIBUTEArray);
            long l = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, this.publicValue), this.privateKey.keyID, cK_ATTRIBUTEArray);
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            this.token.p11.C_GetAttributeValue(session.id(), l, cK_ATTRIBUTEArray);
            byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
            this.token.p11.C_DestroyObject(session.id(), l);
            byte[] byArray2 = P11KeyAgreement.trimZeroes(byArray);
            return byArray2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not generate secret", pKCS11Exception);
        }
        finally {
            this.publicValue = null;
            this.token.releaseSession(session);
        }
    }

    private static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (this.multiPartyAgreement != null) {
            int n2 = this.multiPartyAgreement.generateSecret(byArray, n);
            this.multiPartyAgreement = null;
            return n2;
        }
        if (n + this.secretLen > byArray.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (byArray.length - n) + " available");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        int n;
        if (this.multiPartyAgreement != null) {
            SecretKey secretKey = this.multiPartyAgreement.generateSecret(string);
            this.multiPartyAgreement = null;
            return secretKey;
        }
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        byte[] byArray = this.engineGenerateSecret();
        if (string.equalsIgnoreCase("DES")) {
            n = 8;
        } else if (string.equalsIgnoreCase("DESede")) {
            n = 24;
        } else if (string.equalsIgnoreCase("Blowfish")) {
            n = Math.min(56, byArray.length);
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm " + string);
        }
        if (byArray.length < n) {
            throw new InvalidKeyException("Secret too short");
        }
        return new SecretKeySpec(byArray, 0, n, string);
    }
}

