/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import sun.swing.plaf.synth.DefaultSynthStyle;

class ParsedSynthStyle
extends DefaultSynthStyle {
    private static SynthPainter DELEGATING_PAINTER_INSTANCE = new DelegatingPainter();
    private PainterInfo[] _painters;

    private static PainterInfo[] mergePainterInfo(PainterInfo[] painterInfoArray, PainterInfo[] painterInfoArray2) {
        if (painterInfoArray == null) {
            return painterInfoArray2;
        }
        if (painterInfoArray2 == null) {
            return painterInfoArray;
        }
        int n = painterInfoArray.length;
        int n2 = painterInfoArray2.length;
        int n3 = 0;
        PainterInfo[] painterInfoArray3 = new PainterInfo[n + n2];
        System.arraycopy(painterInfoArray, 0, painterInfoArray3, 0, n);
        for (int i = 0; i < n2; ++i) {
            boolean bl = false;
            for (int j = 0; j < n - n3; ++j) {
                if (!painterInfoArray2[i].equalsPainter(painterInfoArray[j])) continue;
                painterInfoArray3[j] = painterInfoArray2[i];
                ++n3;
                bl = true;
                break;
            }
            if (bl) continue;
            painterInfoArray3[n + i - n3] = painterInfoArray2[i];
        }
        if (n3 > 0) {
            PainterInfo[] painterInfoArray4 = painterInfoArray3;
            painterInfoArray3 = new PainterInfo[painterInfoArray3.length - n3];
            System.arraycopy(painterInfoArray4, 0, painterInfoArray3, 0, painterInfoArray3.length);
        }
        return painterInfoArray3;
    }

    public ParsedSynthStyle() {
    }

    public ParsedSynthStyle(DefaultSynthStyle defaultSynthStyle) {
        super(defaultSynthStyle);
        if (defaultSynthStyle instanceof ParsedSynthStyle) {
            ParsedSynthStyle parsedSynthStyle = (ParsedSynthStyle)defaultSynthStyle;
            if (parsedSynthStyle._painters != null) {
                this._painters = parsedSynthStyle._painters;
            }
        }
    }

    public SynthPainter getPainter(SynthContext synthContext) {
        return DELEGATING_PAINTER_INSTANCE;
    }

    public void setPainters(PainterInfo[] painterInfoArray) {
        this._painters = painterInfoArray;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (!(defaultSynthStyle instanceof ParsedSynthStyle)) {
            defaultSynthStyle = new ParsedSynthStyle(defaultSynthStyle);
        }
        ParsedSynthStyle parsedSynthStyle = (ParsedSynthStyle)super.addTo(defaultSynthStyle);
        parsedSynthStyle._painters = ParsedSynthStyle.mergePainterInfo(parsedSynthStyle._painters, this._painters);
        return parsedSynthStyle;
    }

    private SynthPainter getBestPainter(SynthContext synthContext, String string, int n) {
        SynthPainter synthPainter;
        StateInfo stateInfo = (StateInfo)this.getStateInfo(synthContext.getComponentState());
        if (stateInfo != null && (synthPainter = this.getBestPainter(stateInfo.getPainters(), string, n)) != null) {
            return synthPainter;
        }
        synthPainter = this.getBestPainter(this._painters, string, n);
        if (synthPainter != null) {
            return synthPainter;
        }
        return SynthPainter.NULL_PAINTER;
    }

    private SynthPainter getBestPainter(PainterInfo[] painterInfoArray, String string, int n) {
        if (painterInfoArray != null) {
            SynthPainter synthPainter = null;
            SynthPainter synthPainter2 = null;
            for (int i = painterInfoArray.length - 1; i >= 0; --i) {
                PainterInfo painterInfo = painterInfoArray[i];
                if (painterInfo.getMethod() == string) {
                    if (painterInfo.getDirection() == n) {
                        return painterInfo.getPainter();
                    }
                    if (synthPainter2 != null || painterInfo.getDirection() != -1) continue;
                    synthPainter2 = painterInfo.getPainter();
                    continue;
                }
                if (synthPainter != null || painterInfo.getMethod() != null) continue;
                synthPainter = painterInfo.getPainter();
            }
            if (synthPainter2 != null) {
                return synthPainter2;
            }
            return synthPainter;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this._painters != null) {
            stringBuffer.append(",painters=[");
            for (int i = 0; i < this._painters.length; ++i) {
                stringBuffer.append(this._painters[i].toString());
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    private static class DelegatingPainter
    extends SynthPainter {
        private DelegatingPainter() {
        }

        private static SynthPainter getPainter(SynthContext synthContext, String string, int n) {
            return ((ParsedSynthStyle)synthContext.getStyle()).getBestPainter(synthContext, string, n);
        }

        public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "arrowButtonBackground", -1).paintArrowButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintArrowButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "arrowButtonBorder", -1).paintArrowButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "arrowButtonForeground", n5).paintArrowButtonForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "buttonBackground", -1).paintButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "buttonBorder", -1).paintButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkBoxMenuItemBackground", -1).paintCheckBoxMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintCheckBoxMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkBoxMenuItemBorder", -1).paintCheckBoxMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkBoxBackground", -1).paintCheckBoxBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintCheckBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "checkBoxBorder", -1).paintCheckBoxBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintColorChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "colorChooserBackground", -1).paintColorChooserBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintColorChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "colorChooserBorder", -1).paintColorChooserBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintComboBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "comboBoxBackground", -1).paintComboBoxBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintComboBoxBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "comboBoxBorder", -1).paintComboBoxBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintDesktopIconBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktopIconBackground", -1).paintDesktopIconBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintDesktopIconBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktopIconBorder", -1).paintDesktopIconBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktopPaneBackground", -1).paintDesktopPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintDesktopPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "desktopPaneBorder", -1).paintDesktopPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintEditorPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "editorPaneBackground", -1).paintEditorPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintEditorPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "editorPaneBorder", -1).paintEditorPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintFileChooserBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "fileChooserBackground", -1).paintFileChooserBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintFileChooserBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "fileChooserBorder", -1).paintFileChooserBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintFormattedTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "formattedTextFieldBackground", -1).paintFormattedTextFieldBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintFormattedTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "formattedTextFieldBorder", -1).paintFormattedTextFieldBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintInternalFrameTitlePaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalFrameTitlePaneBackground", -1).paintInternalFrameTitlePaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintInternalFrameTitlePaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalFrameTitlePaneBorder", -1).paintInternalFrameTitlePaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintInternalFrameBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalFrameBackground", -1).paintInternalFrameBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "internalFrameBorder", -1).paintInternalFrameBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintLabelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "labelBackground", -1).paintLabelBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintLabelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "labelBorder", -1).paintLabelBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintListBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "listBackground", -1).paintListBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintListBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "listBorder", -1).paintListBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuBarBackground", -1).paintMenuBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintMenuBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuBarBorder", -1).paintMenuBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuItemBackground", -1).paintMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuItemBorder", -1).paintMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuBackground", -1).paintMenuBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "menuBorder", -1).paintMenuBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintOptionPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "optionPaneBackground", -1).paintOptionPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintOptionPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "optionPaneBorder", -1).paintOptionPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintPanelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "panelBackground", -1).paintPanelBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintPanelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "panelBorder", -1).paintPanelBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintPasswordFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "passwordFieldBackground", -1).paintPasswordFieldBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintPasswordFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "passwordFieldBorder", -1).paintPasswordFieldBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintPopupMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "popupMenuBackground", -1).paintPopupMenuBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintPopupMenuBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "popupMenuBorder", -1).paintPopupMenuBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "progressBarBackground", -1).paintProgressBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "progressBarBorder", -1).paintProgressBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "progressBarForeground", n5).paintProgressBarForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radioButtonMenuItemBackground", -1).paintRadioButtonMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintRadioButtonMenuItemBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radioButtonMenuItemBorder", -1).paintRadioButtonMenuItemBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radioButtonBackground", -1).paintRadioButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintRadioButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "radioButtonBorder", -1).paintRadioButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintRootPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "rootPaneBackground", -1).paintRootPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintRootPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "rootPaneBorder", -1).paintRootPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollBarBackground", -1).paintScrollBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollBarBorder", -1).paintScrollBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollBarThumbBackground", n5).paintScrollBarThumbBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintScrollBarThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "scrollBarThumbBorder", n5).paintScrollBarThumbBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollBarTrackBackground", -1).paintScrollBarTrackBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollBarTrackBorder", -1).paintScrollBarTrackBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintScrollPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollPaneBackground", -1).paintScrollPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "scrollPaneBorder", -1).paintScrollPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "separatorBackground", -1).paintSeparatorBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "separatorBorder", -1).paintSeparatorBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSeparatorForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "separatorForeground", n5).paintSeparatorForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "sliderBackground", -1).paintSliderBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "sliderBorder", -1).paintSliderBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "sliderThumbBackground", n5).paintSliderThumbBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintSliderThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "sliderThumbBorder", n5).paintSliderThumbBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "sliderTrackBackground", -1).paintSliderTrackBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "sliderTrackBorder", -1).paintSliderTrackBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSpinnerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "spinnerBackground", -1).paintSpinnerBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSpinnerBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "spinnerBorder", -1).paintSpinnerBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "splitPaneDividerBackground", -1).paintSplitPaneDividerBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSplitPaneDividerForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "splitPaneDividerForeground", n5).paintSplitPaneDividerForeground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintSplitPaneDragDivider(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "splitPaneDragDivider", n5).paintSplitPaneDragDivider(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintSplitPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "splitPaneBackground", -1).paintSplitPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintSplitPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "splitPaneBorder", -1).paintSplitPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTabbedPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneBackground", -1).paintTabbedPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTabbedPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneBorder", -1).paintTabbedPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTabbedPaneTabAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneTabAreaBackground", -1).paintTabbedPaneTabAreaBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTabbedPaneTabAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneTabAreaBorder", -1).paintTabbedPaneTabAreaBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneTabBackground", -1).paintTabbedPaneTabBackground(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintTabbedPaneTabBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneTabBorder", -1).paintTabbedPaneTabBorder(synthContext, graphics, n, n2, n3, n4, n5);
        }

        public void paintTabbedPaneContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneContentBackground", -1).paintTabbedPaneContentBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTabbedPaneContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tabbedPaneContentBorder", -1).paintTabbedPaneContentBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTableHeaderBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tableHeaderBackground", -1).paintTableHeaderBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTableHeaderBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tableHeaderBorder", -1).paintTableHeaderBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTableBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tableBackground", -1).paintTableBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTableBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "tableBorder", -1).paintTableBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textAreaBackground", -1).paintTextAreaBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTextAreaBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textAreaBorder", -1).paintTextAreaBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTextPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textPaneBackground", -1).paintTextPaneBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTextPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textPaneBorder", -1).paintTextPaneBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textFieldBackground", -1).paintTextFieldBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTextFieldBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "textFieldBorder", -1).paintTextFieldBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toggleButtonBackground", -1).paintToggleButtonBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToggleButtonBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toggleButtonBorder", -1).paintToggleButtonBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolBarBackground", -1).paintToolBarBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolBarBorder", -1).paintToolBarBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolBarContentBackground", -1).paintToolBarContentBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolBarContentBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolBarContentBorder", -1).paintToolBarContentBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolBarDragWindowBackground", -1).paintToolBarDragWindowBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolBarDragWindowBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolBarDragWindowBorder", -1).paintToolBarDragWindowBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolTipBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolTipBackground", -1).paintToolTipBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintToolTipBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "toolTipBorder", -1).paintToolTipBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTreeBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treeBackground", -1).paintTreeBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTreeBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treeBorder", -1).paintTreeBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTreeCellBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treeCellBackground", -1).paintTreeCellBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTreeCellBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treeCellBorder", -1).paintTreeCellBorder(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintTreeCellFocus(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "treeCellFocus", -1).paintTreeCellFocus(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintViewportBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "viewportBackground", -1).paintViewportBackground(synthContext, graphics, n, n2, n3, n4);
        }

        public void paintViewportBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            DelegatingPainter.getPainter(synthContext, "viewportBorder", -1).paintViewportBorder(synthContext, graphics, n, n2, n3, n4);
        }
    }

    static class PainterInfo {
        private String _method;
        private SynthPainter _painter;
        private int _direction;

        PainterInfo(String string, SynthPainter synthPainter, int n) {
            if (string != null) {
                this._method = string.intern();
            }
            this._painter = synthPainter;
            this._direction = n;
        }

        String getMethod() {
            return this._method;
        }

        SynthPainter getPainter() {
            return this._painter;
        }

        int getDirection() {
            return this._direction;
        }

        private boolean equalsPainter(PainterInfo painterInfo) {
            return this._method == painterInfo._method && this._direction == painterInfo._direction;
        }

        public String toString() {
            return "PainterInfo {method=" + this._method + ",direction=" + this._direction + ",painter=" + this._painter + "}";
        }
    }

    static class StateInfo
    extends DefaultSynthStyle.StateInfo {
        private PainterInfo[] _painterInfo;

        public StateInfo() {
        }

        public StateInfo(DefaultSynthStyle.StateInfo stateInfo) {
            super(stateInfo);
            if (stateInfo instanceof StateInfo) {
                this._painterInfo = ((StateInfo)stateInfo)._painterInfo;
            }
        }

        public void setPainters(PainterInfo[] painterInfoArray) {
            this._painterInfo = painterInfoArray;
        }

        public PainterInfo[] getPainters() {
            return this._painterInfo;
        }

        public Object clone() {
            return new StateInfo(this);
        }

        public DefaultSynthStyle.StateInfo addTo(DefaultSynthStyle.StateInfo stateInfo) {
            if (!(stateInfo instanceof StateInfo)) {
                stateInfo = new StateInfo(stateInfo);
            } else {
                stateInfo = super.addTo(stateInfo);
                StateInfo stateInfo2 = (StateInfo)stateInfo;
                stateInfo2._painterInfo = ParsedSynthStyle.mergePainterInfo(stateInfo2._painterInfo, this._painterInfo);
            }
            return stateInfo;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(",painters=[");
            if (this._painterInfo != null) {
                for (int i = 0; i < this._painterInfo.length; ++i) {
                    stringBuffer.append("    ").append(this._painterInfo[i].toString());
                }
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

