/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    private static final MenuSelectionManager instance = new MenuSelectionManager();
    private Vector selection = new Vector();
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public static MenuSelectionManager defaultManager() {
        return instance;
    }

    public void setSelectedPath(MenuElement[] menuElementArray) {
        int n;
        int n2 = this.selection.size();
        int n3 = 0;
        if (menuElementArray == null) {
            menuElementArray = new MenuElement[]{};
        }
        int n4 = menuElementArray.length;
        for (n = 0; n < n4 && n < n2 && (MenuElement)this.selection.elementAt(n) == menuElementArray[n]; ++n) {
            ++n3;
        }
        for (n = n2 - 1; n >= n3; --n) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(n);
            this.selection.removeElementAt(n);
            menuElement.menuSelectionChanged(false);
        }
        n4 = menuElementArray.length;
        for (n = n3; n < n4; ++n) {
            if (menuElementArray[n] == null) continue;
            this.selection.addElement(menuElementArray[n]);
            menuElementArray[n].menuSelectionChanged(true);
        }
        this.fireStateChanged();
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selection.size()];
        int n = this.selection.size();
        for (int i = 0; i < n; ++i) {
            menuElementArray[i] = (MenuElement)this.selection.elementAt(i);
        }
        return menuElementArray;
    }

    public void clearSelectedPath() {
        if (this.selection.size() > 0) {
            this.setSelectedPath(null);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Component component = (Component)mouseEvent.getSource();
        if (!component.isShowing()) {
            return;
        }
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getModifiers();
        if ((n == 504 || n == 505) && (n2 & 0x1C) != 0) {
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        int n3 = point.x;
        int n4 = point.y;
        Vector vector = (Vector)this.selection.clone();
        int n5 = vector.size();
        boolean bl = false;
        for (int i = n5 - 1; i >= 0 && !bl; --i) {
            MenuElement menuElement = (MenuElement)vector.elementAt(i);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n6 = menuElementArray.length;
            for (int j = 0; j < n6 && !bl; ++j) {
                Serializable serializable;
                int n7;
                int n8;
                Component component2;
                if (menuElementArray[j] == null || !(component2 = menuElementArray[j].getComponent()).isShowing()) continue;
                if (component2 instanceof JComponent) {
                    n8 = ((JComponent)component2).getWidth();
                    n7 = ((JComponent)component2).getHeight();
                } else {
                    Rectangle rectangle = component2.getBounds();
                    n8 = rectangle.width;
                    n7 = rectangle.height;
                }
                point.x = n3;
                point.y = n4;
                SwingUtilities.convertPointFromScreen(point, component2);
                if (point.x < 0 || point.x >= n8 || point.y < 0 || point.y >= n7) continue;
                if (menuElementArray2 == null) {
                    menuElementArray2 = new MenuElement[i + 2];
                    for (int k = 0; k <= i; ++k) {
                        menuElementArray2[k] = (MenuElement)vector.elementAt(k);
                    }
                }
                menuElementArray2[i + 1] = menuElementArray[j];
                MenuElement[] menuElementArray3 = this.getSelectedPath();
                if (menuElementArray3[menuElementArray3.length - 1] != menuElementArray2[i + 1] && (menuElementArray3.length < 2 || menuElementArray3[menuElementArray3.length - 2] != menuElementArray2[i + 1])) {
                    serializable = menuElementArray3[menuElementArray3.length - 1].getComponent();
                    MouseEvent mouseEvent2 = new MouseEvent((Component)serializable, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    menuElementArray3[menuElementArray3.length - 1].processMouseEvent(mouseEvent2, menuElementArray2, this);
                    MouseEvent mouseEvent3 = new MouseEvent(component2, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    menuElementArray[j].processMouseEvent(mouseEvent3, menuElementArray2, this);
                }
                serializable = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                menuElementArray[j].processMouseEvent((MouseEvent)serializable, menuElementArray2, this);
                bl = true;
                mouseEvent.consume();
            }
        }
    }

    private void printMenuElementArray(MenuElement[] menuElementArray) {
        this.printMenuElementArray(menuElementArray, false);
    }

    private void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                System.out.print("  ");
            }
            MenuElement menuElement = menuElementArray[i];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
                continue;
            }
            if (menuElement instanceof JMenuBar) {
                System.out.println("JMenuBar, ");
                continue;
            }
            if (menuElement instanceof JPopupMenu) {
                System.out.println("JPopupMenu, ");
                continue;
            }
            if (menuElement == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + menuElement + ", ");
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        int n = point2.x;
        int n2 = point2.y;
        Vector vector = (Vector)this.selection.clone();
        int n3 = vector.size();
        for (int i = n3 - 1; i >= 0; --i) {
            MenuElement menuElement = (MenuElement)vector.elementAt(i);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            int n4 = menuElementArray.length;
            for (int j = 0; j < n4; ++j) {
                int n5;
                int n6;
                Component component2;
                if (menuElementArray[j] == null || !(component2 = menuElementArray[j].getComponent()).isShowing()) continue;
                if (component2 instanceof JComponent) {
                    n6 = ((JComponent)component2).getWidth();
                    n5 = ((JComponent)component2).getHeight();
                } else {
                    Rectangle rectangle = component2.getBounds();
                    n6 = rectangle.width;
                    n5 = rectangle.height;
                }
                point2.x = n;
                point2.y = n2;
                SwingUtilities.convertPointFromScreen(point2, component2);
                if (point2.x < 0 || point2.x >= n6 || point2.y < 0 || point2.y >= n5) continue;
                return component2;
            }
        }
        return null;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        MenuElement[] menuElementArray;
        MenuElement[] menuElementArray2 = new MenuElement[]{};
        int n = (menuElementArray2 = this.selection.toArray(menuElementArray2)).length;
        if (n < 1) {
            return;
        }
        for (int i = n - 1; i >= 0; --i) {
            MenuElement menuElement = menuElementArray2[i];
            MenuElement[] menuElementArray3 = menuElement.getSubElements();
            menuElementArray = null;
            for (int j = 0; j < menuElementArray3.length; ++j) {
                if (menuElementArray3[j] == null || !menuElementArray3[j].getComponent().isShowing() || !menuElementArray3[j].getComponent().isEnabled()) continue;
                if (menuElementArray == null) {
                    menuElementArray = new MenuElement[i + 2];
                    System.arraycopy(menuElementArray2, 0, menuElementArray, 0, i + 1);
                }
                menuElementArray[i + 1] = menuElementArray3[j];
                menuElementArray3[j].processKeyEvent(keyEvent, menuElementArray, this);
                if (!keyEvent.isConsumed()) continue;
                return;
            }
        }
        menuElementArray = new MenuElement[]{menuElementArray2[0]};
        menuElementArray[0].processKeyEvent(keyEvent, menuElementArray, this);
        if (keyEvent.isConsumed()) {
            return;
        }
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        if (this.selection.size() > 0) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(0);
            return this.isComponentPartOfCurrentMenu(menuElement, component);
        }
        return false;
    }

    private boolean isComponentPartOfCurrentMenu(MenuElement menuElement, Component component) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement.getComponent() == component) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n = menuElementArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.isComponentPartOfCurrentMenu(menuElementArray[i], component)) continue;
            return true;
        }
        return false;
    }
}

