/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xerces.internal.util.EncodingMap;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class EncodingInfo {
    private static Method fgGetConverterMethod = null;
    private static Method fgCanConvertMethod = null;
    private static boolean fgConvertersAvailable = false;
    private Object[] fArgsForMethod = null;
    String ianaName;
    String javaName;
    int lastPrintable;
    Object fCharToByteConverter = null;
    boolean fHaveTriedCToB = false;
    Charset nioCharset = null;
    CharsetEncoder nioCharEncoder = null;

    public EncodingInfo(String string, String string2, int n) {
        this.ianaName = string;
        this.javaName = EncodingMap.getIANA2JavaMapping(string);
        this.lastPrintable = n;
        try {
            this.nioCharset = Charset.forName(this.javaName);
            if (this.nioCharset.canEncode()) {
                this.nioCharEncoder = this.nioCharset.newEncoder();
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            this.nioCharset = null;
            this.nioCharEncoder = null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            this.nioCharset = null;
            this.nioCharEncoder = null;
        }
    }

    public String getIANAName() {
        return this.ianaName;
    }

    public Writer getWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        if (this.javaName != null) {
            return new OutputStreamWriter(outputStream, this.javaName);
        }
        this.javaName = EncodingMap.getIANA2JavaMapping(this.ianaName);
        if (this.javaName == null) {
            return new OutputStreamWriter(outputStream, "UTF8");
        }
        return new OutputStreamWriter(outputStream, this.javaName);
    }

    public boolean isPrintable(char c) {
        if (c <= this.lastPrintable) {
            return true;
        }
        if (this.nioCharEncoder != null) {
            return this.nioCharEncoder.canEncode(c);
        }
        if (this.fCharToByteConverter == null) {
            if (this.fHaveTriedCToB || !fgConvertersAvailable) {
                return false;
            }
            if (this.fArgsForMethod == null) {
                this.fArgsForMethod = new Object[1];
            }
            try {
                this.fArgsForMethod[0] = this.javaName;
                this.fCharToByteConverter = fgGetConverterMethod.invoke(null, this.fArgsForMethod);
            }
            catch (Exception exception) {
                this.fHaveTriedCToB = true;
                return false;
            }
        }
        try {
            this.fArgsForMethod[0] = new Character(c);
            return (Boolean)fgCanConvertMethod.invoke(this.fCharToByteConverter, this.fArgsForMethod);
        }
        catch (Exception exception) {
            this.fCharToByteConverter = null;
            this.fHaveTriedCToB = false;
            return false;
        }
    }

    public static void testJavaEncodingName(String string) throws UnsupportedEncodingException {
        byte[] byArray = new byte[]{118, 97, 108, 105, 100};
        String string2 = new String(byArray, string);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.io.CharToByteConverter");
            fgGetConverterMethod = clazz.getMethod("getConverter", String.class);
            fgCanConvertMethod = clazz.getMethod("canConvert", Character.TYPE);
            fgConvertersAvailable = true;
        }
        catch (Exception exception) {
            fgGetConverterMethod = null;
            fgCanConvertMethod = null;
            fgConvertersAvailable = false;
        }
    }
}

