/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.CodeCache;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.interpreter.Interpreter;
import sun.jvm.hotspot.interpreter.InterpreterCodelet;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;

public class PStack
extends Tool {
    private Map jframeCache;
    private PrintStream out;
    private boolean verbose;

    public PStack(boolean v) {
        this.verbose = v;
    }

    public PStack() {
        this(true);
    }

    public void run() {
        this.out = System.out;
        Debugger dbg = this.getAgent().getDebugger();
        CDebugger cdbg = dbg.getCDebugger();
        if (cdbg != null) {
            boolean isJava = this.getAgent().isJavaMode();
            if (isJava) {
                this.initJFrameCache();
            }
            List l = cdbg.getThreadList();
            boolean cdbgCanDemangle = cdbg.canDemangle();
            Iterator itr = l.iterator();
            while (itr.hasNext()) {
                try {
                    ThreadProxy th = (ThreadProxy)itr.next();
                    this.out.print("----------------- ");
                    this.out.print(th);
                    this.out.println(" -----------------");
                    for (CFrame f = cdbg.topFrameForThread(th); f != null; f = f.sender()) {
                        ClosestSymbol sym = f.closestSymbolToPC();
                        Address pc = f.pc();
                        if (sym != null) {
                            String name = sym.getName();
                            if (cdbgCanDemangle) {
                                name = cdbg.demangle(name);
                            }
                            this.out.print(pc + "\t" + name);
                            long diff = sym.getOffset();
                            if (diff != 0L) {
                                this.out.print(" + 0x" + Long.toHexString(diff));
                            }
                            this.out.println();
                            continue;
                        }
                        if (isJava) {
                            String[] names = null;
                            Interpreter interp = VM.getVM().getInterpreter();
                            if (interp.contains(pc)) {
                                names = this.getJavaNames(th, f.localVariableBase());
                                if (names == null || names.length == 0) {
                                    String desc;
                                    this.out.print("<interpreter> ");
                                    InterpreterCodelet ic = interp.getCodeletContaining(pc);
                                    if (ic != null && (desc = ic.getDescription()) != null) {
                                        this.out.print(desc);
                                    }
                                    this.out.println();
                                }
                            } else {
                                CodeCache c = VM.getVM().getCodeCache();
                                if (c.contains(pc)) {
                                    this.out.print(pc + "\t");
                                    CodeBlob cb = c.findBlobUnsafe(pc);
                                    if (cb.isNMethod()) {
                                        names = this.getJavaNames(th, f.localVariableBase());
                                        if (names == null || names.length == 0) {
                                            this.out.println("<Unknown compiled code>");
                                        }
                                    } else if (cb.isBufferBlob()) {
                                        this.out.println("<StubRoutines>");
                                    } else if (cb.isRuntimeStub()) {
                                        this.out.println("<RuntimeStub>");
                                    } else if (cb.isI2CAdapter()) {
                                        this.out.println("<I2CAdapter>");
                                    } else if (cb.isC2IAdapter()) {
                                        this.out.println("<C2IAdapter>");
                                    } else if (cb.isOSRAdapter()) {
                                        this.out.println("<OSRAdapter>");
                                    } else if (cb.isDeoptimizationStub()) {
                                        this.out.println("<DeoptimizationStub>");
                                    } else if (cb.isUncommonTrapStub()) {
                                        this.out.println("<UncommonTrap>");
                                    } else if (cb.isExceptionStub()) {
                                        this.out.println("<ExceptionStub>");
                                    } else if (cb.isSafepointStub()) {
                                        this.out.println("<SafepointStub>");
                                    } else {
                                        this.out.println("<Unknown code blob>");
                                    }
                                } else {
                                    this.printUnknown(pc);
                                }
                            }
                            if (names == null || names.length == 0) continue;
                            for (int i = 0; i < names.length; ++i) {
                                this.out.println(pc + "\t" + names[i]);
                            }
                            continue;
                        }
                        this.printUnknown(pc);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        } else if (this.getDebugeeType() == 2) {
            this.out.println("remote configuration is not yet implemented");
        } else {
            this.out.println("not yet implemented (debugger does not support CDebugger)!");
        }
    }

    protected boolean requiresVM() {
        return false;
    }

    public static void main(String[] args) throws Exception {
        PStack t = new PStack();
        t.start(args);
        t.stop();
    }

    private void initJFrameCache() {
        this.jframeCache = new HashMap();
        Threads threads = VM.getVM().getThreads();
        for (JavaThread cur = threads.first(); cur != null; cur = cur.next()) {
            ArrayList<JavaVFrame> tmp = new ArrayList<JavaVFrame>(10);
            try {
                for (JavaVFrame vf = cur.getLastJavaVFrameDbg(); vf != null; vf = vf.javaSender()) {
                    tmp.add(vf);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            JavaVFrame[] jvframes = new JavaVFrame[tmp.size()];
            System.arraycopy(tmp.toArray(), 0, jvframes, 0, jvframes.length);
            this.jframeCache.put(cur.getThreadProxy(), jvframes);
        }
    }

    private void printUnknown(Address pc) {
        this.out.println(pc + "\t????????");
    }

    private String[] getJavaNames(ThreadProxy th, Address fp) {
        if (fp == null) {
            return null;
        }
        JavaVFrame[] jvframes = (JavaVFrame[])this.jframeCache.get(th);
        if (jvframes == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(10);
        for (int fCount = 0; fCount < jvframes.length; ++fCount) {
            JavaVFrame vf = jvframes[fCount];
            Frame f = vf.getFrame();
            if (!((Object)fp).equals(f.getFP())) continue;
            StringBuffer sb = new StringBuffer();
            Method method = vf.getMethod();
            sb.append("* ");
            sb.append(method.externalNameAndSignature());
            sb.append(" bci:" + vf.getBCI());
            int lineNumber = method.getLineNumberFromBCI(vf.getBCI());
            if (lineNumber != -1) {
                sb.append(" line:" + lineNumber);
            }
            if (this.verbose) {
                sb.append(" methodOop:" + method.getHandle());
            }
            if (vf.isCompiledFrame()) {
                sb.append(" (Compiled frame");
            } else if (vf.isInterpretedFrame()) {
                sb.append(" (Interpreted frame");
            }
            if (vf.mayBeImpreciseDbg()) {
                sb.append("; information may be imprecise");
            }
            sb.append(")");
            names.add(sb.toString());
        }
        String[] res = new String[names.size()];
        System.arraycopy(names.toArray(), 0, res, 0, res.length);
        return res;
    }
}

