/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class GenerationSpec
extends VMObject {
    private static CIntegerField nameField;
    private static CIntegerField initSizeField;
    private static CIntegerField maxSizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("GenerationSpec");
        nameField = type.getCIntegerField("_name");
        initSizeField = type.getCIntegerField("_init_size");
        maxSizeField = type.getCIntegerField("_max_size");
    }

    public GenerationSpec(Address addr) {
        super(addr);
    }

    public Generation.Name name() {
        return Generation.nameForEnum((int)nameField.getValue(this.addr));
    }

    public long initSize() {
        return initSizeField.getValue(this.addr);
    }

    public long maxSize() {
        return maxSizeField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                GenerationSpec.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

