/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecodes;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.AssertionFailure;

public class BytecodeStream {
    private Method _method;
    private int _bci;
    private int _next_bci;
    private int _end_bci;
    private int _code;
    private boolean _is_wide;

    public BytecodeStream(Method method) {
        this._method = method;
        this.setInterval(0, (int)method.getCodeSize());
    }

    public void setInterval(int beg_bci, int end_bci) {
        Assert.that(0 <= beg_bci && (long)beg_bci <= this._method.getCodeSize(), "illegal beg_bci");
        Assert.that(0 <= end_bci && (long)end_bci <= this._method.getCodeSize(), "illegal end_bci");
        this._bci = beg_bci;
        this._next_bci = beg_bci;
        this._end_bci = end_bci;
    }

    public void setStart(int beg_bci) {
        this.setInterval(beg_bci, (int)this._method.getCodeSize());
    }

    public int next() {
        int code;
        this._bci = this._next_bci;
        if (this.isLastBytecode()) {
            code = -1;
        } else {
            int rawCode = Bytecodes.codeAt(this._method, this._bci);
            code = 0;
            try {
                code = Bytecodes.javaCode(rawCode);
            }
            catch (AssertionFailure e) {
                e.printStackTrace();
                Assert.that(false, "Failure occurred at bci " + this._bci + " in method " + this._method.externalNameAndSignature());
            }
            int l = Bytecodes.lengthFor(code);
            if (l == 0) {
                l = Bytecodes.lengthAt(this._method, this._bci);
            }
            this._next_bci += l;
            Assert.that(this._bci < this._next_bci, "length must be > 0");
            this._is_wide = false;
            if (code == 196) {
                code = this._method.getBytecodeOrBPAt(this._bci + 1);
                this._is_wide = true;
            }
            Assert.that(Bytecodes.isJavaCode(code), "sanity check");
        }
        this._code = code;
        return this._code;
    }

    public Method method() {
        return this._method;
    }

    public int bci() {
        return this._bci;
    }

    public int nextBCI() {
        return this._next_bci;
    }

    public int endBCI() {
        return this._end_bci;
    }

    public int code() {
        return this._code;
    }

    public boolean isWide() {
        return this._is_wide;
    }

    public boolean isActiveBreakpoint() {
        return Bytecodes.isActiveBreakpointAt(this._method, this._bci);
    }

    public boolean isLastBytecode() {
        return this._next_bci >= this._end_bci;
    }

    public void setNextBCI(int bci) {
        Assert.that(0 <= bci && (long)bci <= this._method.getCodeSize(), "illegal bci");
        this._next_bci = bci;
    }

    public int dest() {
        return this.bci() + this._method.getBytecodeShortArg(this.bci() + 1);
    }

    public int dest_w() {
        return this.bci() + this._method.getBytecodeIntArg(this.bci() + 1);
    }

    public int getIndex() {
        return this.isWide() ? this._method.getBytecodeShortArg(this.bci() + 2) & 0xFFFF : this._method.getBytecodeOrBPAt(this.bci() + 1) & 0xFF;
    }

    public int getIndexBig() {
        return this._method.getBytecodeShortArg(this.bci() + 1);
    }

    public int codeAt(int bci) {
        return this._method.getBytecodeOrBPAt(bci);
    }
}

