/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Paint;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java2d.AnimatingSurface;

public class GradAnim
extends AnimatingSurface {
    private static final int MAX_HUE = 1536;
    private animval x1;
    private animval y1;
    private animval x2;
    private animval y2;
    private int hue = (int)(Math.random() * 1536.0);

    public GradAnim() {
        this.setBackground(Color.white);
        this.x1 = new animval(0, 300, 2, 10);
        this.y1 = new animval(0, 300, 2, 10);
        this.x2 = new animval(0, 300, 2, 10);
        this.y2 = new animval(0, 300, 2, 10);
    }

    public void reset(int n, int n2) {
        this.x1.newlimits(0, n);
        this.y1.newlimits(0, n2);
        this.x2.newlimits(0, n);
        this.y2.newlimits(0, n2);
    }

    public void step(int n, int n2) {
        this.x1.anim();
        this.y1.anim();
        this.x2.anim();
        this.y2.anim();
        this.hue = (this.hue + (int)(Math.random() * 10.0)) % 1536;
    }

    public static Color getColor(int n) {
        int n2 = n / 256 % 6;
        int n3 = n % 256 * 2;
        int n4 = n3 < 256 ? 255 : 511 - n3;
        int n5 = n3 < 256 ? n3 : 255;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        switch (n2) {
            case 0: {
                n8 = 255;
                break;
            }
            case 1: {
                n8 = n4;
                n7 = n5;
                break;
            }
            case 2: {
                n7 = 255;
                break;
            }
            case 3: {
                n7 = n4;
                n6 = n5;
                break;
            }
            case 4: {
                n6 = 255;
                break;
            }
            case 5: {
                n6 = n4;
                n8 = n5;
            }
        }
        return new Color(n8, n7, n6);
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        Color color = GradAnim.getColor(this.hue);
        Color color2 = GradAnim.getColor(this.hue + 768);
        GradientPaint gradientPaint = new GradientPaint(this.x1.getFlt(), this.y1.getFlt(), color, this.x2.getFlt(), this.y2.getFlt(), color2, true);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.yellow);
        graphics2D.drawLine(this.x1.getInt(), this.y1.getInt(), this.x2.getInt(), this.y2.getInt());
    }

    public static void main(String[] stringArray) {
        GradAnim.createDemoFrame(new GradAnim());
    }

    public class animval {
        float curval;
        float lowval;
        float highval;
        float currate;
        float lowrate;
        float highrate;

        public animval(int n, int n2, int n3, int n4) {
            this.lowval = n;
            this.highval = n2;
            this.lowrate = n3;
            this.highrate = n4;
            this.curval = this.randval(n, n2);
            this.currate = this.randval(n3, n4);
        }

        public float randval(float f, float f2) {
            return (float)((double)f + Math.random() * (double)(f2 - f));
        }

        public float getFlt() {
            return this.curval;
        }

        public int getInt() {
            return (int)this.curval;
        }

        public void anim() {
            this.curval += this.currate;
            this.clip();
        }

        public void clip() {
            if (this.curval > this.highval) {
                this.curval = this.highval - (this.curval - this.highval);
                if (this.curval < this.lowval) {
                    this.curval = this.highval;
                }
                this.currate = -this.randval(this.lowrate, this.highrate);
            } else if (this.curval < this.lowval) {
                this.curval = this.lowval + (this.lowval - this.curval);
                if (this.curval > this.highval) {
                    this.curval = this.lowval;
                }
                this.currate = this.randval(this.lowrate, this.highrate);
            }
        }

        public void newlimits(int n, int n2) {
            this.lowval = n;
            this.highval = n2;
            this.clip();
        }
    }
}

