/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	glyph.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_glyph class header
 *
 *	RCSid = "$Id: glyph.H,v 4.14.1.1 1993/06/01 22:54:41 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_glyph_H
#define OI_glyph_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

#ifndef OI_pic_H
#include <OI/pic.H>
#endif /* OI_pic_H */

	// class forward reference declaration
	class OI_mdl_glyph;

typedef	int	OI_int_num;	/* This is due to a BUG in C++ 2.0, which gets confused in resolving between OI_number & OI_bool */
// typedef OI_number OI_int_num;

		enum OI_glyph_type {
			OI_glyph_none		= 0x0,
			OI_GLYPH_NONE		= OI_glyph_none,
			OI_glyph_mask		= 0x10,		/* bit to find any of the MASK types */
			OI_GLYPH_MASK		= OI_glyph_mask,
			OI_glyph_mask_file	= 0x11,
			OI_GLYPH_MASK_FILE	= OI_glyph_mask_file,
			OI_glyph_mask_data	= 0x12,
			OI_GLYPH_MASK_DATA	= OI_glyph_mask_data,
			OI_glyph_mask_pixmap	= 0x14,
			OI_GLYPH_MASK_PIXMAP	= OI_glyph_mask_pixmap,
			OI_glyph_image		= 0x20,
			OI_GLYPH_IMAGE		= OI_glyph_image,
			OI_glyph_file		= 0x21,
			OI_GLYPH_FILE		= OI_glyph_file,
			OI_glyph_data		= 0x22,
			OI_GLYPH_DATA		= OI_glyph_data,
			OI_glyph_pixmap		= 0x24,
			OI_GLYPH_PIXMAP		= OI_glyph_pixmap
		} ;

 /* ctl_bits private bits */
#define		OI_GLYPH_ANIMATE		0x1		/* 1 => animation in process */
#define		OI_GLYPH_MASK_CLICK_EVENTS	0x2		/* 1 => events using mask for ButtonPress are on object */
#define		OI_GLYPH_NOMASK_CLICK_EVENTS	0x4		/* 1 => events using empty mask for ButtonPress are on object */
#define		OI_GLYPH_DELETE_PIXMAP		0x8		/* 1 => delete pixmap when destroyed */
#define		OI_GLYPH_ANIMATE_CONTINUOUS	0x10		/* 1 => animation continuously */
#define		OI_GLYPH_ANIMATE_TERM_STABLE	0x20		/* 1 => use initial bitmap when animation terminates */
#define		OI_GLYPH_HIGHLIGHT		0x40		/* 1 => Highlight the glyph when button is pressed. */

	class OI_glyph : public OI_w_d_tech {
			OI_mdl_glyph	*mdl_dep;		/* pointer to the model dependent aspect of the object. */
			unsigned long	ctl_bits ;		/* class private control bits */
			OI_pic_type	typ ;			/* type of background */
			OI_number	dp ;			/* depth of pixmap */
			char		*shape_fil_namp ;	/* ptr to bitmap file name string for shape mask */
			char		*labelp ;		/* ptr to label string for glyph */
			OI_number	btn ;			/* btn # for clicks */
			OI_number	n_click ;		/* # clicks which have occurred */
			Time		tim ;			/* time of last button press/release event */
			Pixmap		animate_pm ;		/* last pixmap used for animation, to detect reuse and optimize */
			Pixmap		*animate_frmp ;		/* ptr to series of pixmaps to use for successive frames */
			long		animate_nfr ;		/* # frames in animation sequence */
			long		animate_next ;		/* # for next frame to paint */
			long		animate_ms ;		/* time interval for uniform animation */
			OI_pic_image	*pim;			/* Pointer to underlying image. */
			Pixmap		bnd_bm ;		/* bounding mask for shape extension */
	 protected:
		static	XrmQuark	q_cbAnimate ;		/* quark for animate callback */
		static	XrmQuark	q_cbClick ;		/* quark for click callback */
 		static	XrmQuark	q_highlight;		/* quark for highlight flag. */
 		static	XrmQuark	q_activeFile;		/* quark for active file */
	 public:
		static	OI_class	*clsp ;			/* ptr to class record */

	 private:
			void		construct(const char*, const char*, OI_glyph_type, OI_int_num, OI_int_num, OI_int_num,
						OI_bool=OI_yes);
			void		construct(Pixmap,Pixmap,const char*,OI_pic_type,OI_int_num, OI_int_num, OI_int_num, OI_bool,
						OI_bool=OI_yes);
			void		construct(const char*, const char*, const char*, OI_pic_type, OI_bool, OI_bool=OI_yes);
			void		construct(const char*, const char*, const char*, OI_pic_type, OI_int_num, OI_int_num,OI_int_num,
						OI_bool,OI_bool=OI_yes);
			void		construct(OI_int_num, OI_pic_spec_mask **, const char *, OI_int_num, OI_int_num, OI_bool,
						OI_bool=OI_yes);
			void		construct(OI_number, OI_pic_spec**, const char *, OI_number, OI_number, OI_number, OI_bool) ;
			void		construct(OI_number, OI_pic_spec_mask**, const char *, OI_number, OI_number, OI_bool,
						OI_pic_pixel) ;
			void		construct(const char *fn, const char *lbl =NULL, OI_pic_type t=OI_pic_mask, OI_bool hlt = OI_no,
						OI_bool dflg =OI_yes)
									{construct(fn, NULL, lbl, t, hlt, dflg);}
			void		construct(const char *dtp, const char*lbl, OI_pic_type t, OI_int_num x, OI_int_num y,
						OI_int_num z=0, OI_bool hlt = OI_no, OI_bool dflg=OI_yes)
									{ construct(dtp, (const char *)NULL, lbl, t, x, y, z, hlt, dflg); }
			void		construct(Pixmap p, const char*lbl, OI_pic_type t, OI_int_num x, OI_int_num y, OI_int_num z =0,
						OI_bool hlt = OI_no, OI_bool dflg=OI_yes)
									{ construct(p, (Pixmap)NULL, lbl, t, x, y, z, hlt, dflg); }
			void		allow_animate_continuous()	{ ctl_bits |= OI_GLYPH_ANIMATE_CONTINUOUS; }
			void		allow_animate_term_stable()	{ ctl_bits |= OI_GLYPH_ANIMATE_TERM_STABLE; }
			void		allow_delete_pixmap()		{ ctl_bits |= OI_GLYPH_DELETE_PIXMAP; }
 			void		allow_highlight()		{ ctl_bits |= OI_GLYPH_HIGHLIGHT; }
			void		allow_mask_click_events()	{ ctl_bits |= OI_GLYPH_MASK_CLICK_EVENTS; }
			void		allow_nomask_click_events()	{ ctl_bits |= OI_GLYPH_NOMASK_CLICK_EVENTS; }
			OI_bool		animate_continuous()		{ return((ctl_bits&OI_GLYPH_ANIMATE_CONTINUOUS) ? OI_yes : OI_no); }
			OI_bool		animate_term_stable()		{ return((ctl_bits&OI_GLYPH_ANIMATE_TERM_STABLE) ? OI_yes : OI_no); }
			OI_bool		delete_pixmap()			{ return((ctl_bits&OI_GLYPH_DELETE_PIXMAP) ? OI_yes : OI_no); }
			void		disallow_animate_continuous()	{ ctl_bits &= ~OI_GLYPH_ANIMATE_CONTINUOUS; }
			void		disallow_animate_term_stable()	{ ctl_bits &= ~OI_GLYPH_ANIMATE_TERM_STABLE; }
			void		disallow_delete_pixmap()	{ ctl_bits &= ~OI_GLYPH_DELETE_PIXMAP; }
 			void		disallow_highlight()		{ ctl_bits &= ~OI_GLYPH_HIGHLIGHT; }
			void		disallow_mask_click_events()	{ ctl_bits &= ~OI_GLYPH_MASK_CLICK_EVENTS; }
			void		disallow_nomask_click_events()	{ ctl_bits &= ~OI_GLYPH_NOMASK_CLICK_EVENTS; }
			OI_bool		is_mask_click_events()		{ return((ctl_bits & OI_GLYPH_MASK_CLICK_EVENTS) ?
										OI_yes : OI_no); }
			OI_bool		is_nomask_click_events()	{ return((ctl_bits & OI_GLYPH_NOMASK_CLICK_EVENTS) ?
										OI_yes : OI_no); }
			char		*get_active_file_name();
			char		*get_file_name();
			void		new_shape(Pixmap) ;
			void		refresh_my_callback(OI_cb_inf*) ;
 			OI_stat		res_active_file_name(void *);
			void		res_label(void *);
			void		res_file_name(void *);
 			void		res_highlight(void *);
			void		res_shape_file_name(void *);
	 protected:
					OI_glyph(OI_class*,const char*, const char*, const char*, OI_glyph_type,
						OI_int_num, OI_int_num, OI_int_num, OI_bool=OI_yes);
					OI_glyph(OI_class*,const char*,Pixmap,Pixmap,const char*,OI_pic_type,OI_int_num, OI_int_num,
						OI_int_num, OI_bool, OI_bool=OI_yes);
					OI_glyph(OI_class*,const char*, const char*, const char*, const char*, OI_pic_type, OI_bool,
						OI_bool=OI_yes);
					OI_glyph(OI_class*,const char*, const char*, const char*, const char*, OI_pic_type, OI_int_num,
						OI_int_num,OI_int_num, OI_bool,OI_bool=OI_yes);
					OI_glyph(OI_class*,const char *, OI_int_num, OI_pic_spec_mask **, const char *, OI_int_num,
						OI_int_num, OI_bool, OI_bool=OI_yes);
					OI_glyph(OI_class *clsp, const char *usr_namp, OI_number nbm, OI_pic_spec **psp, const char *lp,
						OI_number w, OI_number h, OI_number d, OI_bool del=OI_yes) ;
					OI_glyph(OI_class *clsp, const char *usr_namp, OI_number nbm, OI_pic_spec_mask **psp,
						const char *lp, OI_number w, OI_number h, OI_bool del, OI_pic_pixel actbkg) ;
			void		animate_custom_cb(OI_animate_fnp fp, OI_callback *objp, OI_animate_memfnp mfp, void*) ;
												/* start customized animation */
			void		do_frame(void*) ;					/* do next animation frame */
		virtual	void		new_model(OI_model_type) ;
			OI_pic_image	*pic_image()		{ return(pim); }

	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_glyph(const char*, const char*, const char*, OI_glyph_type, OI_int_num, OI_int_num,
						OI_int_num, OI_bool=OI_yes);
					OI_glyph(const char*,Pixmap,Pixmap,const char*,OI_pic_type,OI_int_num, OI_int_num, OI_int_num,
						OI_bool, OI_bool=OI_yes);
					OI_glyph(const char*, const char*, const char*, const char*, OI_pic_type, OI_bool, OI_bool=OI_yes);
					OI_glyph(const char*, const char*, const char*, const char*, OI_pic_type,
						OI_int_num, OI_int_num,OI_int_num,OI_bool,OI_bool=OI_yes);
					OI_glyph(const char *, OI_int_num, OI_pic_spec_mask **, const char *,
						OI_int_num, OI_int_num, OI_bool, OI_bool=OI_yes);
					OI_glyph(const char *, OI_number, OI_pic_spec **, const char *, OI_number, OI_number, OI_number,
						OI_bool=OI_yes);
					OI_glyph(const char *, OI_number, OI_pic_spec_mask **, const char *, OI_number, OI_number,
						OI_bool=OI_yes, OI_pic_pixel =OI_PIC_DOWN);
					~OI_glyph () ;
			OI_pic_type	bkg_type()		{return(typ);}
		virtual	void		clone_adjust(OI_d_tech*) ;
			OI_stat		create() ;				/* create in X environment) */
			void		disable() ;
		friend	void		dmpOI_glyph(OI_glyph*) ;		/* diagnostic dump procedure */
			void		enable() ;
		static	OI_bool		init(OI_connection*) ;
		static	OI_glyph	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
 			OI_stat		new_active_file_name(const char*);
 			void		new_highlight(OI_bool);
		virtual	void		paint(const XEvent*, void* =NULL);	/* process expose event */
			void		select(const XEvent*) ;			/* process clicks */
			void		set_type(OI_pic_type t)	{ typ=t; }
	virtual	const	char		*wm_name() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_pic_pixel	active_bkg(PIXEL * =NULL);
			void		animate(long,long,Pixmap*,unsigned int=OI_animate_single, unsigned int=OI_animate_term_stable) ;
													/* start animation */
			void		animate_custom(OI_animate_fnp fp, void *argp=NULL) ;				/* start customized animation */
			void		animate_custom(OI_callback *objp, OI_animate_memfnp mfp, void *argp=NULL) ;	/* start customized animation */
			void		animate_off(unsigned int=OI_animate_term_stable) ;		/* terminate animation */
			char		*file_name(OI_number i=0) ;
			OI_bool		is_animate()		{return(OI_bool)((ctl_bits&OI_GLYPH_ANIMATE) != 0);}
													/* OI_yes => animation in process */
 			OI_bool		is_highlight()		{ return((ctl_bits & OI_GLYPH_HIGHLIGHT) ? OI_yes : OI_no); }
			OI_bool		is_shaped()		{ return(bnd_bm ? OI_yes : OI_no); }
			char		*label()		{return(labelp);}
			void		set_active_bkg(OI_pic_pixel picval, PIXEL =OI_unknown_pixel);
 			OI_stat		set_active_file_name(const char*);
			OI_stat		set_file(const char*, const char * =NULL, OI_pic_type = OI_pic_mask,  OI_bool=OI_no, OI_bool=OI_yes) ;
			OI_stat		set_file(OI_number, OI_pic_spec_mask **, OI_bool=OI_no, OI_bool=OI_yes) ;
 			void		set_highlight(OI_bool =OI_yes);
			OI_stat		set_label(const char*) ;
			OI_stat		set_pixel_data(const char*, const char*, OI_number, OI_number, OI_number=0, OI_bool=OI_no,
						OI_bool=OI_yes);
			OI_stat		set_pixel_data(const char *nd, OI_number x,OI_number y,OI_number z=0,OI_bool h=OI_no,
						OI_bool dflg=OI_yes) ;
			OI_stat		set_pixel_data(OI_number, OI_pic_spec_mask **, OI_number, OI_number, OI_bool=OI_no,OI_bool=OI_yes);
			OI_stat		set_pixmap(Pixmap,Pixmap,OI_int_num,OI_int_num,OI_int_num=0, OI_bool=OI_no, OI_bool=OI_yes) ;
														/* change pixmap */
			OI_stat		set_pixmap(Pixmap p,OI_int_num x,OI_int_num y,OI_int_num z=0,OI_bool h=OI_no, OI_bool dflg=OI_yes) ;
			OI_stat		set_pixmap(OI_number,OI_pic_spec_mask **,OI_number,OI_number,OI_bool=OI_no,OI_bool=OI_yes) ;
			void		set_shape(const char*) ;
			void		set_shape(const char*, OI_number bnd_w, OI_number bnd_h) ;
			void		set_shape(Pixmap) ;
			Pixmap		shape_bound_mask()	{ return(bnd_bm); }
			char		*shape_file_name() ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_glyph *oi_create_glyph(const char *n, const char *fn, const char *lbl, OI_glyph_type,
			OI_int_num x=0, OI_int_num y=0, OI_int_num z=0, OI_bool dflg =OI_yes);

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		


		OI_glyph *oi_create_glyph(const char*, Pixmap, Pixmap, const char*, OI_pic_type, OI_int_num, OI_int_num, OI_int_num =0,
			OI_bool =OI_no, OI_bool =OI_yes);

		OI_glyph *oi_create_glyph(const char *n, Pixmap p, const char *lbl, OI_pic_type t, OI_int_num x, OI_int_num y,
			OI_int_num z =0, OI_bool hlt = OI_no, OI_bool dflg=OI_yes) ;

		OI_glyph *oi_create_glyph(const char*, const char*, const char*, const char*, OI_pic_type,
			OI_int_num, OI_int_num, OI_int_num =0, OI_bool =OI_no, OI_bool=OI_yes);

		OI_glyph *oi_create_glyph(const char *n, const char *dtp, const char *lbl, OI_pic_type t,
			OI_int_num x, OI_int_num y, OI_int_num z=0, OI_bool hlt = OI_no, OI_bool dflg=OI_yes) ;

		OI_glyph *oi_create_glyph(const char*, const char*, const char*, const char*, OI_pic_type =OI_pic_mask,
			OI_bool =OI_no, OI_bool =OI_yes);

		OI_glyph *oi_create_glyph(const char *n, const char *fn, const char *lbl =NULL, OI_pic_type t=OI_pic_mask,
			OI_bool hlt = OI_no, OI_bool dflg =OI_yes) ;

		OI_glyph *oi_create_glyph(const char*, OI_int_num, OI_pic_spec_mask**, const char* =NULL,
			OI_int_num=0, OI_int_num=0, OI_bool=OI_no, OI_bool=OI_yes);

#endif /* OI_glyph_H */
