/*
  This file is part of GNU Taler
  Copyright (C) 2012-2025 Taler Systems SA

  GNU Taler is free software: you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published
  by the Free Software Foundation, either version 3 of the License,
  or (at your option) any later version.

  GNU Taler is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  SPDX-License-Identifier: LGPL3.0-or-later

  Note: the LGPL does not apply to all components of GNU Taler,
  but it does apply to this file.
 */

/**
 * Imports.
 */

export const TalerAmlProperties = {
  /**
   * Description: Current note on the GWG file.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  FILE_NOTE: "FILE_NOTE" as const,
  /**
   * Description: Customer name or internal alias.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  CUSTOMER_LABEL: "CUSTOMER_LABEL" as const,
  /**
   * Description: Boolean flag indicating whether the account has been opened. The definition of opening an account is deployment-specific.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_OPEN: "ACCOUNT_OPEN" as const,
  /**
   * Description: True if the customer is a domestic PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_DOMESTIC: "PEP_DOMESTIC" as const,
  /**
   * Description: True if the customer is a foreign PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_FOREIGN: "PEP_FOREIGN" as const,
  /**
   * Description: True if the customer is a international organization PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION" as const,
  /**
   * Description: True if the customer is a  high-risk business.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_CUSTOMER: "HIGH_RISK_CUSTOMER" as const,
  /**
   * Description: True if the customer is associated with a high-risk country.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY" as const,
  /**
   * Description: The account has been marked as idle.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_IDLE: "ACCOUNT_IDLE" as const,
  /**
   * Description: The MROS reporting state for the account.
   *
   * GANA Type: 'NONE' | 'INVESTIGATION_PENDING' | 'INVESTIGATION_COMPLETED_WITHOUT_SUSPICION' | 'REPORTED_SUSPICION_SIMPLE' | 'REPORTED_SUSPICION_SUBSTANTIATED'
   * Deployment: TOPS
   */
  INVESTIGATION_STATE: "INVESTIGATION_STATE" as const,
  /**
   * Description: Informal reason why the AML investigation was triggered. Examples include suspicious transaction or (automated) sanction list match
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  INVESTIGATION_TRIGGER: "INVESTIGATION_TRIGGER" as const,
  /**
   * Description: Identifies the sanction list entry that the account matched against (best match, does not mean it was a good match)
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  SANCTION_LIST_BEST_MATCH: "SANCTION_LIST_BEST_MATCH" as const,
  /**
   * Description: Score for how good the sanction list match was (0: none, 10**9: perfect match)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_RATING: "SANCTION_LIST_RATING" as const,
  /**
   * Description: Score for how much supporting data we had for the sanction list match (0: none, 10**9: all fields available)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_CONFIDENCE: "SANCTION_LIST_CONFIDENCE" as const,
  /**
   * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS" as const,
};
