/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { ComponentChildren, createContext, h, VNode } from "preact";
import { useContext, useState } from "preact/hooks";

const TALER_SCREEN_ID = 102;

interface Type {
  showDebugInfo: boolean;
  toggle(): void;
}

const initial: Type = {
  showDebugInfo: true,
  toggle() {},
};
// @ts-expect-error asd
const Context = createContext<Type>(undefined);

export const CommonPreferenceProvider = ({
  showDebug,
  children,
}: {
  showDebug?: boolean;
  children: ComponentChildren;
}): VNode => {
  const [value, update] = useState<boolean>(showDebug ?? false);

  return h(Context.Provider, {
    value: {
      showDebugInfo: !!value,
      toggle() {
        update(!value);
      },
    },
    children,
  });
};

export const useCommonPreference = (): Type => useContext(Context);

// /**
//  * User common preferences.
//  *
//  * @returns tuple of [state, update()]
//  */
// export function useCommonPreference(): [boolean, () => void] {
//   const {showDebugInfo, toggle} = useContext(Context);

//   return [showDebugInfo, toggle];
// }

