/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_finalize_transfer_status.h
 * @brief implementation of the finalize_transfer_status function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_FINALIZE_TRANSFER_STATUS_H
#define PG_FINALIZE_TRANSFER_STATUS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Finalize transfer status.
 *
 * @param cls closure
 * @param exchange_url the exchange that made the transfer
 * @param wtid wire transfer subject
 * @param h_details hash over all of the aggregated deposits
 * @param total_amount total amount exchange claimed to have transferred
 * @param wire_fee wire fee charged by the exchange
 * @param exchange_pub key used to make @e exchange_sig
 * @param exchange_sig signature of the exchange over reconciliation data
 * @return database transaction status
 */
enum GNUNET_DB_QueryStatus
TMH_PG_finalize_transfer_status (
  void *cls,
  const char *exchange_url,
  const struct TALER_WireTransferIdentifierRawP *wtid,
  const struct GNUNET_HashCode *h_details,
  const struct TALER_Amount *total_amount,
  const struct TALER_Amount *wire_fee,
  const struct TALER_ExchangePublicKeyP *exchange_pub,
  const struct TALER_ExchangeSignatureP *exchange_sig);


#endif
