package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPolarxCommodity invokes the polardbx.GetPolarxCommodity API synchronously
func (client *Client) GetPolarxCommodity(request *GetPolarxCommodityRequest) (response *GetPolarxCommodityResponse, err error) {
	response = CreateGetPolarxCommodityResponse()
	err = client.DoAction(request, response)
	return
}

// GetPolarxCommodityWithChan invokes the polardbx.GetPolarxCommodity API asynchronously
func (client *Client) GetPolarxCommodityWithChan(request *GetPolarxCommodityRequest) (<-chan *GetPolarxCommodityResponse, <-chan error) {
	responseChan := make(chan *GetPolarxCommodityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPolarxCommodity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPolarxCommodityWithCallback invokes the polardbx.GetPolarxCommodity API asynchronously
func (client *Client) GetPolarxCommodityWithCallback(request *GetPolarxCommodityRequest, callback func(response *GetPolarxCommodityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPolarxCommodityResponse
		var err error
		defer close(result)
		response, err = client.GetPolarxCommodity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPolarxCommodityRequest is the request struct for api GetPolarxCommodity
type GetPolarxCommodityRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	OrderType      string `position:"Query" name:"OrderType"`
}

// GetPolarxCommodityResponse is the response struct for api GetPolarxCommodity
type GetPolarxCommodityResponse struct {
	*responses.BaseResponse
	RequestId     string                         `json:"RequestId" xml:"RequestId"`
	DBInstance    DBInstanceInGetPolarxCommodity `json:"DBInstance" xml:"DBInstance"`
	ComponentList []Component                    `json:"ComponentList" xml:"ComponentList"`
}

// CreateGetPolarxCommodityRequest creates a request to invoke GetPolarxCommodity API
func CreateGetPolarxCommodityRequest() (request *GetPolarxCommodityRequest) {
	request = &GetPolarxCommodityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "GetPolarxCommodity", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPolarxCommodityResponse creates a response to parse from GetPolarxCommodity response
func CreateGetPolarxCommodityResponse() (response *GetPolarxCommodityResponse) {
	response = &GetPolarxCommodityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
