package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRoomName invokes the itaas.UpdateRoomName API synchronously
// api document: https://help.aliyun.com/api/itaas/updateroomname.html
func (client *Client) UpdateRoomName(request *UpdateRoomNameRequest) (response *UpdateRoomNameResponse, err error) {
	response = CreateUpdateRoomNameResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRoomNameWithChan invokes the itaas.UpdateRoomName API asynchronously
// api document: https://help.aliyun.com/api/itaas/updateroomname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRoomNameWithChan(request *UpdateRoomNameRequest) (<-chan *UpdateRoomNameResponse, <-chan error) {
	responseChan := make(chan *UpdateRoomNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRoomName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRoomNameWithCallback invokes the itaas.UpdateRoomName API asynchronously
// api document: https://help.aliyun.com/api/itaas/updateroomname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRoomNameWithCallback(request *UpdateRoomNameRequest, callback func(response *UpdateRoomNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRoomNameResponse
		var err error
		defer close(result)
		response, err = client.UpdateRoomName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRoomNameRequest is the request struct for api UpdateRoomName
type UpdateRoomNameRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Drname      string `position:"Query" name:"Drname"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
	Screencode  string `position:"Query" name:"Screencode"`
}

// UpdateRoomNameResponse is the response struct for api UpdateRoomName
type UpdateRoomNameResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	ErrorCode int                       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                    `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                      `json:"Success" xml:"Success"`
	ErrorList ErrorListInUpdateRoomName `json:"ErrorList" xml:"ErrorList"`
}

// CreateUpdateRoomNameRequest creates a request to invoke UpdateRoomName API
func CreateUpdateRoomNameRequest() (request *UpdateRoomNameRequest) {
	request = &UpdateRoomNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "UpdateRoomName", "itaas", "openAPI")
	return
}

// CreateUpdateRoomNameResponse creates a response to parse from UpdateRoomName response
func CreateUpdateRoomNameResponse() (response *UpdateRoomNameResponse) {
	response = &UpdateRoomNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
