package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupStatus invokes the hbase.DescribeBackupStatus API synchronously
func (client *Client) DescribeBackupStatus(request *DescribeBackupStatusRequest) (response *DescribeBackupStatusResponse, err error) {
	response = CreateDescribeBackupStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupStatusWithChan invokes the hbase.DescribeBackupStatus API asynchronously
func (client *Client) DescribeBackupStatusWithChan(request *DescribeBackupStatusRequest) (<-chan *DescribeBackupStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupStatusWithCallback invokes the hbase.DescribeBackupStatus API asynchronously
func (client *Client) DescribeBackupStatusWithCallback(request *DescribeBackupStatusRequest, callback func(response *DescribeBackupStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupStatusRequest is the request struct for api DescribeBackupStatus
type DescribeBackupStatusRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeBackupStatusResponse is the response struct for api DescribeBackupStatus
type DescribeBackupStatusResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ClusterId    string `json:"ClusterId" xml:"ClusterId"`
	BackupStatus string `json:"BackupStatus" xml:"BackupStatus"`
	BdsClusterId string `json:"BdsClusterId" xml:"BdsClusterId"`
}

// CreateDescribeBackupStatusRequest creates a request to invoke DescribeBackupStatus API
func CreateDescribeBackupStatusRequest() (request *DescribeBackupStatusRequest) {
	request = &DescribeBackupStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeBackupStatus", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupStatusResponse creates a response to parse from DescribeBackupStatus response
func CreateDescribeBackupStatusResponse() (response *DescribeBackupStatusResponse) {
	response = &DescribeBackupStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
