package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateXpackMonitorConfig invokes the elasticsearch.UpdateXpackMonitorConfig API synchronously
func (client *Client) UpdateXpackMonitorConfig(request *UpdateXpackMonitorConfigRequest) (response *UpdateXpackMonitorConfigResponse, err error) {
	response = CreateUpdateXpackMonitorConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateXpackMonitorConfigWithChan invokes the elasticsearch.UpdateXpackMonitorConfig API asynchronously
func (client *Client) UpdateXpackMonitorConfigWithChan(request *UpdateXpackMonitorConfigRequest) (<-chan *UpdateXpackMonitorConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateXpackMonitorConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateXpackMonitorConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateXpackMonitorConfigWithCallback invokes the elasticsearch.UpdateXpackMonitorConfig API asynchronously
func (client *Client) UpdateXpackMonitorConfigWithCallback(request *UpdateXpackMonitorConfigRequest, callback func(response *UpdateXpackMonitorConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateXpackMonitorConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateXpackMonitorConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateXpackMonitorConfigRequest is the request struct for api UpdateXpackMonitorConfig
type UpdateXpackMonitorConfigRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
}

// UpdateXpackMonitorConfigResponse is the response struct for api UpdateXpackMonitorConfig
type UpdateXpackMonitorConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateUpdateXpackMonitorConfigRequest creates a request to invoke UpdateXpackMonitorConfig API
func CreateUpdateXpackMonitorConfigRequest() (request *UpdateXpackMonitorConfigRequest) {
	request = &UpdateXpackMonitorConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateXpackMonitorConfig", "/openapi/logstashes/[InstanceId]/xpack-monitor-config", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateXpackMonitorConfigResponse creates a response to parse from UpdateXpackMonitorConfig response
func CreateUpdateXpackMonitorConfigResponse() (response *UpdateXpackMonitorConfigResponse) {
	response = &UpdateXpackMonitorConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
