package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateResourceDLink invokes the eas.UpdateResourceDLink API synchronously
func (client *Client) UpdateResourceDLink(request *UpdateResourceDLinkRequest) (response *UpdateResourceDLinkResponse, err error) {
	response = CreateUpdateResourceDLinkResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateResourceDLinkWithChan invokes the eas.UpdateResourceDLink API asynchronously
func (client *Client) UpdateResourceDLinkWithChan(request *UpdateResourceDLinkRequest) (<-chan *UpdateResourceDLinkResponse, <-chan error) {
	responseChan := make(chan *UpdateResourceDLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateResourceDLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateResourceDLinkWithCallback invokes the eas.UpdateResourceDLink API asynchronously
func (client *Client) UpdateResourceDLinkWithCallback(request *UpdateResourceDLinkRequest, callback func(response *UpdateResourceDLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateResourceDLinkResponse
		var err error
		defer close(result)
		response, err = client.UpdateResourceDLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateResourceDLinkRequest is the request struct for api UpdateResourceDLink
type UpdateResourceDLinkRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	ClusterId  string `position:"Path" name:"ClusterId"`
	Body       string `position:"Body" name:"body"`
}

// UpdateResourceDLinkResponse is the response struct for api UpdateResourceDLink
type UpdateResourceDLinkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateResourceDLinkRequest creates a request to invoke UpdateResourceDLink API
func CreateUpdateResourceDLinkRequest() (request *UpdateResourceDLinkRequest) {
	request = &UpdateResourceDLinkRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "UpdateResourceDLink", "/api/v2/resources/[ClusterId]/[ResourceId]/dlink", "eas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateResourceDLinkResponse creates a response to parse from UpdateResourceDLink response
func CreateUpdateResourceDLinkResponse() (response *UpdateResourceDLinkResponse) {
	response = &UpdateResourceDLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
