package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescAccountSummary invokes the dm.DescAccountSummary API synchronously
// api document: https://help.aliyun.com/api/dm/descaccountsummary.html
func (client *Client) DescAccountSummary(request *DescAccountSummaryRequest) (response *DescAccountSummaryResponse, err error) {
	response = CreateDescAccountSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescAccountSummaryWithChan invokes the dm.DescAccountSummary API asynchronously
// api document: https://help.aliyun.com/api/dm/descaccountsummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescAccountSummaryWithChan(request *DescAccountSummaryRequest) (<-chan *DescAccountSummaryResponse, <-chan error) {
	responseChan := make(chan *DescAccountSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescAccountSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescAccountSummaryWithCallback invokes the dm.DescAccountSummary API asynchronously
// api document: https://help.aliyun.com/api/dm/descaccountsummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescAccountSummaryWithCallback(request *DescAccountSummaryRequest, callback func(response *DescAccountSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescAccountSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescAccountSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescAccountSummaryRequest is the request struct for api DescAccountSummary
type DescAccountSummaryRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// DescAccountSummaryResponse is the response struct for api DescAccountSummary
type DescAccountSummaryResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	UserStatus    int    `json:"UserStatus" xml:"UserStatus"`
	QuotaLevel    int    `json:"QuotaLevel" xml:"QuotaLevel"`
	MaxQuotaLevel int    `json:"MaxQuotaLevel" xml:"MaxQuotaLevel"`
	DailyQuota    int    `json:"DailyQuota" xml:"DailyQuota"`
	MonthQuota    int    `json:"MonthQuota" xml:"MonthQuota"`
	Tags          int    `json:"Tags" xml:"Tags"`
	Domains       int    `json:"Domains" xml:"Domains"`
	MailAddresses int    `json:"MailAddresses" xml:"MailAddresses"`
	Receivers     int    `json:"Receivers" xml:"Receivers"`
	Templates     int    `json:"Templates" xml:"Templates"`
	DayuStatus    int    `json:"DayuStatus" xml:"DayuStatus"`
	SmsTemplates  int    `json:"SmsTemplates" xml:"SmsTemplates"`
	SmsRecord     int    `json:"SmsRecord" xml:"SmsRecord"`
	SmsSign       int    `json:"SmsSign" xml:"SmsSign"`
	EnableTimes   int    `json:"EnableTimes" xml:"EnableTimes"`
}

// CreateDescAccountSummaryRequest creates a request to invoke DescAccountSummary API
func CreateDescAccountSummaryRequest() (request *DescAccountSummaryRequest) {
	request = &DescAccountSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "DescAccountSummary", "", "")
	return
}

// CreateDescAccountSummaryResponse creates a response to parse from DescAccountSummary response
func CreateDescAccountSummaryResponse() (response *DescAccountSummaryResponse) {
	response = &DescAccountSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
