package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteConstants invokes the dbfs.DeleteConstants API synchronously
func (client *Client) DeleteConstants(request *DeleteConstantsRequest) (response *DeleteConstantsResponse, err error) {
	response = CreateDeleteConstantsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteConstantsWithChan invokes the dbfs.DeleteConstants API asynchronously
func (client *Client) DeleteConstantsWithChan(request *DeleteConstantsRequest) (<-chan *DeleteConstantsResponse, <-chan error) {
	responseChan := make(chan *DeleteConstantsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteConstants(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteConstantsWithCallback invokes the dbfs.DeleteConstants API asynchronously
func (client *Client) DeleteConstantsWithCallback(request *DeleteConstantsRequest, callback func(response *DeleteConstantsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteConstantsResponse
		var err error
		defer close(result)
		response, err = client.DeleteConstants(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteConstantsRequest is the request struct for api DeleteConstants
type DeleteConstantsRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	ConstantsData string           `position:"Query" name:"ConstantsData"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// DeleteConstantsResponse is the response struct for api DeleteConstants
type DeleteConstantsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Data       string `json:"Data" xml:"Data"`
	PageSize   int64  `json:"PageSize" xml:"PageSize"`
	TotalCount int64  `json:"TotalCount" xml:"TotalCount"`
	PageNumber int64  `json:"PageNumber" xml:"PageNumber"`
}

// CreateDeleteConstantsRequest creates a request to invoke DeleteConstants API
func CreateDeleteConstantsRequest() (request *DeleteConstantsRequest) {
	request = &DeleteConstantsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "DeleteConstants", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteConstantsResponse creates a response to parse from DeleteConstants response
func CreateDeleteConstantsResponse() (response *DeleteConstantsResponse) {
	response = &DeleteConstantsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
