package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetConnectionShare invokes the dataworks_public.SetConnectionShare API synchronously
func (client *Client) SetConnectionShare(request *SetConnectionShareRequest) (response *SetConnectionShareResponse, err error) {
	response = CreateSetConnectionShareResponse()
	err = client.DoAction(request, response)
	return
}

// SetConnectionShareWithChan invokes the dataworks_public.SetConnectionShare API asynchronously
func (client *Client) SetConnectionShareWithChan(request *SetConnectionShareRequest) (<-chan *SetConnectionShareResponse, <-chan error) {
	responseChan := make(chan *SetConnectionShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetConnectionShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetConnectionShareWithCallback invokes the dataworks_public.SetConnectionShare API asynchronously
func (client *Client) SetConnectionShareWithCallback(request *SetConnectionShareRequest, callback func(response *SetConnectionShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetConnectionShareResponse
		var err error
		defer close(result)
		response, err = client.SetConnectionShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetConnectionShareRequest is the request struct for api SetConnectionShare
type SetConnectionShareRequest struct {
	*requests.RpcRequest
	ProjectPermissions string           `position:"Query" name:"ProjectPermissions"`
	DatasourceName     string           `position:"Query" name:"DatasourceName"`
	UserPermissions    string           `position:"Query" name:"UserPermissions"`
	EnvType            string           `position:"Query" name:"EnvType"`
	ProjectId          requests.Integer `position:"Query" name:"ProjectId"`
}

// SetConnectionShareResponse is the response struct for api SetConnectionShare
type SetConnectionShareResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSetConnectionShareRequest creates a request to invoke SetConnectionShare API
func CreateSetConnectionShareRequest() (request *SetConnectionShareRequest) {
	request = &SetConnectionShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "SetConnectionShare", "", "")
	request.Method = requests.POST
	return
}

// CreateSetConnectionShareResponse creates a response to parse from SetConnectionShare response
func CreateSetConnectionShareResponse() (response *SetConnectionShareResponse) {
	response = &SetConnectionShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
