package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigRuleSummaryByRiskLevel invokes the config.GetConfigRuleSummaryByRiskLevel API synchronously
func (client *Client) GetConfigRuleSummaryByRiskLevel(request *GetConfigRuleSummaryByRiskLevelRequest) (response *GetConfigRuleSummaryByRiskLevelResponse, err error) {
	response = CreateGetConfigRuleSummaryByRiskLevelResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigRuleSummaryByRiskLevelWithChan invokes the config.GetConfigRuleSummaryByRiskLevel API asynchronously
func (client *Client) GetConfigRuleSummaryByRiskLevelWithChan(request *GetConfigRuleSummaryByRiskLevelRequest) (<-chan *GetConfigRuleSummaryByRiskLevelResponse, <-chan error) {
	responseChan := make(chan *GetConfigRuleSummaryByRiskLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigRuleSummaryByRiskLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigRuleSummaryByRiskLevelWithCallback invokes the config.GetConfigRuleSummaryByRiskLevel API asynchronously
func (client *Client) GetConfigRuleSummaryByRiskLevelWithCallback(request *GetConfigRuleSummaryByRiskLevelRequest, callback func(response *GetConfigRuleSummaryByRiskLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigRuleSummaryByRiskLevelResponse
		var err error
		defer close(result)
		response, err = client.GetConfigRuleSummaryByRiskLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigRuleSummaryByRiskLevelRequest is the request struct for api GetConfigRuleSummaryByRiskLevel
type GetConfigRuleSummaryByRiskLevelRequest struct {
	*requests.RpcRequest
}

// GetConfigRuleSummaryByRiskLevelResponse is the response struct for api GetConfigRuleSummaryByRiskLevel
type GetConfigRuleSummaryByRiskLevelResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	ConfigRuleSummaries []Data `json:"ConfigRuleSummaries" xml:"ConfigRuleSummaries"`
}

// CreateGetConfigRuleSummaryByRiskLevelRequest creates a request to invoke GetConfigRuleSummaryByRiskLevel API
func CreateGetConfigRuleSummaryByRiskLevelRequest() (request *GetConfigRuleSummaryByRiskLevelRequest) {
	request = &GetConfigRuleSummaryByRiskLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetConfigRuleSummaryByRiskLevel", "", "")
	request.Method = requests.GET
	return
}

// CreateGetConfigRuleSummaryByRiskLevelResponse creates a response to parse from GetConfigRuleSummaryByRiskLevel response
func CreateGetConfigRuleSummaryByRiskLevelResponse() (response *GetConfigRuleSummaryByRiskLevelResponse) {
	response = &GetConfigRuleSummaryByRiskLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
