package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBackupPlan invokes the cassandra.DeleteBackupPlan API synchronously
func (client *Client) DeleteBackupPlan(request *DeleteBackupPlanRequest) (response *DeleteBackupPlanResponse, err error) {
	response = CreateDeleteBackupPlanResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBackupPlanWithChan invokes the cassandra.DeleteBackupPlan API asynchronously
func (client *Client) DeleteBackupPlanWithChan(request *DeleteBackupPlanRequest) (<-chan *DeleteBackupPlanResponse, <-chan error) {
	responseChan := make(chan *DeleteBackupPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBackupPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBackupPlanWithCallback invokes the cassandra.DeleteBackupPlan API asynchronously
func (client *Client) DeleteBackupPlanWithCallback(request *DeleteBackupPlanRequest, callback func(response *DeleteBackupPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBackupPlanResponse
		var err error
		defer close(result)
		response, err = client.DeleteBackupPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBackupPlanRequest is the request struct for api DeleteBackupPlan
type DeleteBackupPlanRequest struct {
	*requests.RpcRequest
	DataCenterId string `position:"Query" name:"DataCenterId"`
	ClusterId    string `position:"Query" name:"ClusterId"`
}

// DeleteBackupPlanResponse is the response struct for api DeleteBackupPlan
type DeleteBackupPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteBackupPlanRequest creates a request to invoke DeleteBackupPlan API
func CreateDeleteBackupPlanRequest() (request *DeleteBackupPlanRequest) {
	request = &DeleteBackupPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DeleteBackupPlan", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteBackupPlanResponse creates a response to parse from DeleteBackupPlan response
func CreateDeleteBackupPlanResponse() (response *DeleteBackupPlanResponse) {
	response = &DeleteBackupPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
