package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateWarning invokes the aegis.OperateWarning API synchronously
// api document: https://help.aliyun.com/api/aegis/operatewarning.html
func (client *Client) OperateWarning(request *OperateWarningRequest) (response *OperateWarningResponse, err error) {
	response = CreateOperateWarningResponse()
	err = client.DoAction(request, response)
	return
}

// OperateWarningWithChan invokes the aegis.OperateWarning API asynchronously
// api document: https://help.aliyun.com/api/aegis/operatewarning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateWarningWithChan(request *OperateWarningRequest) (<-chan *OperateWarningResponse, <-chan error) {
	responseChan := make(chan *OperateWarningResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateWarning(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateWarningWithCallback invokes the aegis.OperateWarning API asynchronously
// api document: https://help.aliyun.com/api/aegis/operatewarning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateWarningWithCallback(request *OperateWarningRequest, callback func(response *OperateWarningResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateWarningResponse
		var err error
		defer close(result)
		response, err = client.OperateWarning(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateWarningRequest is the request struct for api OperateWarning
type OperateWarningRequest struct {
	*requests.RpcRequest
	Reason         string `position:"Query" name:"Reason"`
	SourceIp       string `position:"Query" name:"SourceIp"`
	OperateType    string `position:"Query" name:"OperateType"`
	RiskWarningIds string `position:"Query" name:"RiskWarningIds"`
}

// OperateWarningResponse is the response struct for api OperateWarning
type OperateWarningResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateWarningRequest creates a request to invoke OperateWarning API
func CreateOperateWarningRequest() (request *OperateWarningRequest) {
	request = &OperateWarningRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "OperateWarning", "vipaegis", "openAPI")
	return
}

// CreateOperateWarningResponse creates a response to parse from OperateWarning response
func CreateOperateWarningResponse() (response *OperateWarningResponse) {
	response = &OperateWarningResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
