package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCrackStatistics invokes the aegis.GetCrackStatistics API synchronously
// api document: https://help.aliyun.com/api/aegis/getcrackstatistics.html
func (client *Client) GetCrackStatistics(request *GetCrackStatisticsRequest) (response *GetCrackStatisticsResponse, err error) {
	response = CreateGetCrackStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// GetCrackStatisticsWithChan invokes the aegis.GetCrackStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/getcrackstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCrackStatisticsWithChan(request *GetCrackStatisticsRequest) (<-chan *GetCrackStatisticsResponse, <-chan error) {
	responseChan := make(chan *GetCrackStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCrackStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCrackStatisticsWithCallback invokes the aegis.GetCrackStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/getcrackstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCrackStatisticsWithCallback(request *GetCrackStatisticsRequest, callback func(response *GetCrackStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCrackStatisticsResponse
		var err error
		defer close(result)
		response, err = client.GetCrackStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCrackStatisticsRequest is the request struct for api GetCrackStatistics
type GetCrackStatisticsRequest struct {
	*requests.RpcRequest
	EndTime   string `position:"Query" name:"EndTime"`
	StartTime string `position:"Query" name:"StartTime"`
}

// GetCrackStatisticsResponse is the response struct for api GetCrackStatistics
type GetCrackStatisticsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCrackStatisticsRequest creates a request to invoke GetCrackStatistics API
func CreateGetCrackStatisticsRequest() (request *GetCrackStatisticsRequest) {
	request = &GetCrackStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "GetCrackStatistics", "vipaegis", "openAPI")
	return
}

// CreateGetCrackStatisticsResponse creates a response to parse from GetCrackStatistics response
func CreateGetCrackStatisticsResponse() (response *GetCrackStatisticsResponse) {
	response = &GetCrackStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
