/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.jmh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.apache.commons.text.similarity.SimilarityScore;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class LongestCommonSubsequencePerformance {
    @Benchmark
    public void testLCS(InputData data) {
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        for (Pair<CharSequence, CharSequence> input : data.inputs) {
            lcs.longestCommonSubsequence((CharSequence)input.getLeft(), (CharSequence)input.getRight());
        }
    }

    @Benchmark
    public void testLCSBaseline(InputData data) {
        BaselineLongestCommonSubsequence lcs = new BaselineLongestCommonSubsequence();
        for (Pair<CharSequence, CharSequence> input : data.inputs) {
            lcs.longestCommonSubsequence((CharSequence)input.getLeft(), (CharSequence)input.getRight());
        }
    }

    @Benchmark
    public void testLCSLen(InputData data) {
        LongestCommonSubsequence lcs = new LongestCommonSubsequence();
        for (Pair<CharSequence, CharSequence> input : data.inputs) {
            lcs.apply((CharSequence)input.getLeft(), (CharSequence)input.getRight());
        }
    }

    @Benchmark
    public void testLCSLenBaseline(InputData data) {
        BaselineLongestCommonSubsequence lcs = new BaselineLongestCommonSubsequence();
        for (Pair<CharSequence, CharSequence> input : data.inputs) {
            lcs.apply((CharSequence)input.getLeft(), (CharSequence)input.getRight());
        }
    }

    @State(value=Scope.Benchmark)
    public static class InputData {
        final List<Pair<CharSequence, CharSequence>> inputs = new ArrayList<Pair<CharSequence, CharSequence>>();

        @Setup(value=Level.Trial)
        public void setup() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try (InputStream is = classLoader.getResourceAsStream("org/apache/commons/text/lcs-perf-analysis-inputs.csv");
                 InputStreamReader isr = new InputStreamReader(Objects.requireNonNull(is));
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null && !line.trim().isEmpty()) {
                    line = line.trim();
                    int indexOfComma = line.indexOf(44);
                    String inputA = line.substring(0, indexOfComma);
                    String inputB = line.substring(1 + indexOfComma);
                    this.inputs.add((Pair<CharSequence, CharSequence>)ImmutablePair.of((Object)inputA, (Object)inputB));
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception.getMessage(), exception);
            }
        }
    }

    private static final class BaselineLongestCommonSubsequence
    implements SimilarityScore<Integer> {
        private BaselineLongestCommonSubsequence() {
        }

        public Integer apply(CharSequence left, CharSequence right) {
            if (left == null || right == null) {
                throw new IllegalArgumentException("Inputs must not be null");
            }
            return this.longestCommonSubsequence(left, right).length();
        }

        public CharSequence longestCommonSubsequence(CharSequence left, CharSequence right) {
            if (left == null || right == null) {
                throw new IllegalArgumentException("Inputs must not be null");
            }
            StringBuilder longestCommonSubstringArray = new StringBuilder(Math.max(left.length(), right.length()));
            int[][] lcsLengthArray = this.longestCommonSubstringLengthArray(left, right);
            int i = left.length() - 1;
            int j = right.length() - 1;
            int k = lcsLengthArray[left.length()][right.length()] - 1;
            while (k >= 0) {
                if (left.charAt(i) == right.charAt(j)) {
                    longestCommonSubstringArray.append(left.charAt(i));
                    --i;
                    --j;
                    --k;
                    continue;
                }
                if (lcsLengthArray[i + 1][j] < lcsLengthArray[i][j + 1]) {
                    --i;
                    continue;
                }
                --j;
            }
            return longestCommonSubstringArray.reverse().toString();
        }

        public int[][] longestCommonSubstringLengthArray(CharSequence left, CharSequence right) {
            int[][] lcsLengthArray = new int[left.length() + 1][right.length() + 1];
            for (int i = 0; i < left.length(); ++i) {
                for (int j = 0; j < right.length(); ++j) {
                    if (i == 0) {
                        lcsLengthArray[i][j] = 0;
                    }
                    if (j == 0) {
                        lcsLengthArray[i][j] = 0;
                    }
                    lcsLengthArray[i + 1][j + 1] = left.charAt(i) == right.charAt(j) ? lcsLengthArray[i][j] + 1 : Math.max(lcsLengthArray[i + 1][j], lcsLengthArray[i][j + 1]);
                }
            }
            return lcsLengthArray;
        }
    }
}

