/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Formattable;
import java.util.Formatter;
import org.apache.commons.text.FormattableUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormattableUtilsTest {
    private Formatter createFormatter() {
        return new Formatter();
    }

    @Test
    public void testAlternatePadCharacter() {
        int pad = 95;
        Assertions.assertEquals((Object)"foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (char)'_').toString());
        Assertions.assertEquals((Object)"fo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (char)'_').toString());
        Assertions.assertEquals((Object)"_foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (char)'_').toString());
        Assertions.assertEquals((Object)"___foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (char)'_').toString());
        Assertions.assertEquals((Object)"_fo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (char)'_').toString());
        Assertions.assertEquals((Object)"___fo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (char)'_').toString());
        Assertions.assertEquals((Object)"foo_", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (char)'_').toString());
        Assertions.assertEquals((Object)"foo___", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (char)'_').toString());
        Assertions.assertEquals((Object)"fo_", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (char)'_').toString());
        Assertions.assertEquals((Object)"fo___", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (char)'_').toString());
    }

    @Test
    public void testAlternatePadCharAndEllipsis() {
        Assertions.assertEquals((Object)"foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"f*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"_foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"___foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"_f*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"___f*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"foo_", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"foo___", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"f*_", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"f*___", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (char)'_', (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"+*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"_foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"___foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"_+*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"___+*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"foo_", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"foo___", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"+*_", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (char)'_', (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"+*___", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (char)'_', (CharSequence)"+*").toString());
    }

    @Test
    public void testAppendWithNullFormatterAndIntsThrowsNullPointerException() {
        Assertions.assertThrowsExactly(NullPointerException.class, () -> FormattableUtils.append((CharSequence)"", null, (int)0, (int)0, (int)0, (char)'}'));
    }

    @Test
    public void testDefaultAppend() {
        Assertions.assertEquals((Object)"foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1).toString());
        Assertions.assertEquals((Object)"fo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2).toString());
        Assertions.assertEquals((Object)" foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1).toString());
        Assertions.assertEquals((Object)"   foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1).toString());
        Assertions.assertEquals((Object)" fo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2).toString());
        Assertions.assertEquals((Object)"   fo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2).toString());
        Assertions.assertEquals((Object)"foo ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1).toString());
        Assertions.assertEquals((Object)"foo   ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1).toString());
        Assertions.assertEquals((Object)"fo ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2).toString());
        Assertions.assertEquals((Object)"fo   ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2).toString());
    }

    @Test
    public void testEllipsis() {
        Assertions.assertEquals((Object)"foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"f*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)" foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"   foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)" f*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"   f*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"foo ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"foo   ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"f* ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"f*   ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (CharSequence)"*").toString());
        Assertions.assertEquals((Object)"foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"+*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)" foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"   foo", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)" +*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"   +*", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"foo ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"foo   ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"+* ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (CharSequence)"+*").toString());
        Assertions.assertEquals((Object)"+*   ", (Object)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (CharSequence)"+*").toString());
    }

    @Test
    public void testIllegalEllipsis() {
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)1, (CharSequence)"xx"));
    }

    @Test
    public void testIllegalEllipsisWith7Args() {
        String ellipsis = "xxxx";
        int precisionLessThanEllipsisLength = "xxxx".length() - 1;
        Assertions.assertThrowsExactly(IllegalArgumentException.class, () -> FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)0, (int)precisionLessThanEllipsisLength, (char)'}', (CharSequence)"xxxx"));
    }

    @Test
    public void testPublicConstructorExists() {
        new FormattableUtils();
    }

    @Test
    public void testSimplestFormat() {
        SimplestFormattable formattable = new SimplestFormattable("foo");
        Assertions.assertEquals((Object)"foo", (Object)FormattableUtils.toString((Formattable)formattable));
    }

    static class SimplestFormattable
    implements Formattable {
        private final String text;

        SimplestFormattable(String text) {
            this.text = text;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            formatter.format(this.text, new Object[0]);
        }
    }
}

