################################################################################
#
#    (C) Copyright IBM Corp. 2006 All Rights Reserved.
#
#    The source code for this program is not published or
#    otherwise divested of its trade secrets, irrespective of
#    what has been deposited with the U.S. Copyright Office.
#
################################################################################
#set -x

function usage
{
  if [[ -n ${flag_debug} ]]
  then
    set -x
  fi

  echo "Usage: getFastBackSnapshots.sh -i [IP Address] -u [user name] -p [user password] -o [path/FileName] "
  echo "                               -D [Domain] -S [repository] -w [path] -U [User] -v -h -f [path/configFileName] "
  echo ""
  echo "  -i    [Required] IP Address of FastBackShell installation. "
  echo "  -u    [Required] FastBack User Name to authenticat with Fastback shell with. "
  echo "  -p    [Required] FastBack User Name password to authenticat with Fastback shell with. "
  echo "  -D    [Optional] FastBack Server Domain. Default is \"xpress-restore\". "
  echo "  -S    [Optional] Fastback repository share. Default is local repository"
  echo "  -o    [Optional] Path and filename with snapshot list. "
  echo "  -f    [Optional] Path and filename of config file. If not set the default config file is used. "
  echo "  -w    [Optional] FastBackShell path. Default is \"/c/Program Files/Tivoli/TSM/FastBack/shell\". "
  echo "  -U    [Optional] Windows server User. Default is \"Administrator\". "
  echo "  -h    [Optional] Display this help. "
  echo "  -v    [Optional] Verbose. "
  echo ""
}

config_commandFile=`whence $0`
config_configFile=`dirname ${config_commandFile}`/configFile

. `dirname ${config_commandFile}`/commonFunctions

loadConfigFile

while getopts dhvi:u:p:D:S:Z:Q:f:o:w:U: c 2> /dev/null
do
  case $c in
    i) config_FBSIPAddr=${OPTARG};;
    u) config_FBSUserName=${OPTARG};;
    p) config_FBSUserNamePasswd=${OPTARG};;
    D) config_FBSDomain=${OPTARG};;
    S) config_shareRepository=${OPTARG};;
    Z) config_shareRepository_forTSM=${OPTARG};;
    Q) config_shareRepName=${OPTARG};;
    d) set -x
       flag_debug=true;;
    h) usage
       exit;;
    v) flag_verbose=true;;
    f) config_configFile=${OPTARG}
       loadConfigFile;;
    o) config_outputFile=${OPTARG};;
    w) config_FBSDirectory=${OPTARG};;
    U) config_FBSWindowsUser=${OPTARG};;
    *) usage
       exit_print "Wrong Usage" 1;;
  esac
done

if [[ -n ${config_outputFile} ]]
then
  if ! touch ${config_outputFile} > /dev/null 2>&1
  then
    exit_print " Output File ${config_outputFile} is not writable." 24
  fi
  if [[ -d ${config_outputFile} ]]
  then
    exit_print " Output File ${config_outputFile} is a existing directory." 49
  fi
  echo -e "" > ${config_outputFile}
fi

if [[ -z ${config_FBSIPAddr} ]]
then
  exit_print_wFile " You must provide a IP address of the FastBackShell Windows server." 20
fi

if [[ -z ${config_FBSUserName} ]]
then
  exit_print_wFile " You must provide a username for the FastBackShell Windows server." 21
fi

if [[ -z ${config_FBSUserNamePasswd} ]]
then
  exit_print_wFile " You must provide a username password for the FastBackShell Windows server." 22
fi

if [[ -n ${config_shareRepository} && -n ${config_shareRepository_forTSM} ]]
then
  exit_print_wFile "You must provide the -S or -Z option. Not both" 28
fi

verbose_print "Checking Local Dependancies"
config_OSPlatform=`getOSPlatform`
returnCode=$?
if [[ ${returnCode} = 10 ]]
then
  config_OSRedHat="true"
elif [[ ${returnCode} = 11 ]]
then
  config_OSSuSe10="true"
elif [[ ${returnCode} = 12 ]]
then
  config_OSSuSe11="true"
else
  exit_print_wFile "Unsupported OS PLatform: ${config_OSPlatform}" 25
fi
checkLocalDependancies

verbose_print "Executing FastbackShell Command to generate the snapshot list"

variableList="-i ${config_FBSIPAddr}"

if [[ -n ${flag_debug} ]]
then
  variableList="${variableList} -d"
fi

if [[ -n ${flag_verbose} ]]
then
  variableList="${variableList} -v"
fi

if [[ ! -z ${config_FBSWindowsUser} ]]
then
  variableList="${variableList} -U ${config_FBSWindowsUser}"
fi

if [[ ! -z ${config_FBSDirectory} ]]
then
  variableList="${variableList} -w ${config_FBSDirectory}"
fi

commandDir=`dirname ${config_commandFile}`
command="${commandDir}/r_FastBackShell.sh ${variableList} -c"

if [[ -n ${config_FBSDomain} ]]
then
  fsbDomain=${config_FBSDomain}
else
  fsbDomain="xpress-restore"
fi

exec 3>&1
verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} set_connection mount_computer ${config_FBSIPAddr} \""
returnCode=`((${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} set_connection mount_computer ${config_FBSIPAddr}"; echo $? >&4) | tee ${config_outputFile} 1>&3) 4>&1`

# This FastbackShell command does not return 0 on success.
#if [[ ! ${returnCode} = 0 ]]
#then
#  exit_print_wFile " Error occured while Getting Snapshots from FastBackServer. " ${returnCode}
#fi

if [[ -z ${config_shareRepository} && -z ${config_shareRepository_forTSM} ]]
then
  verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount dump -os all -for TSM -full\""
  returnCode=`((${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount dump -os all -for TSM -full "; echo $? >&4) | tee ${config_outputFile} 1>&3) 4>&1`
elif [[ -n ${config_shareRepository_forTSM} ]]
then
  tmpRepository="\"share: \\\\\\\\`echo ${config_shareRepository_forTSM} | awk '{print $1}'`\\\\${config_shareRepName}  domain=`echo ${config_shareRepository_forTSM} | awk '{print $2}'`\""
  verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount dump -os all -for TSM -full -type share -rep ${tmpRepository}\""
  returnCode=`((${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount dump -os all -for TSM -full -type share -rep ${tmpRepository} "; echo $? >&4) | tee ${config_outputFile} 1>&3) 4>&1`
else
  verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount dump -os all -for TSM -full -type share -rep ${config_shareRepository}\""
  returnCode=`((${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount dump -os all -for TSM -full -type share -rep ${config_shareRepository} "; echo $? >&4) | tee ${config_outputFile} 1>&3) 4>&1`
fi

if [[ ! ${returnCode} = 0 ]]
then
  exit_print_wFile " Error occured while Getting Snapshots from FastBackServer. " ${returnCode}
fi


