/***********************************************************************
* Name:
*        dapiutil.c
*
* Function:
*        Utility functions for the sample Tivoli Storage Manager api code
*
* Public Routines:
*    format_number : Format numbers with commas so they can be read
*    initFS:         Fill in platform specific filespace info      
*
* Description:
*        The file contains utility functions for the Tivoli Storage Manager
*        sample api code that do not fit well within other source modules.
***********************************************************************/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "dsmapitd.h"          /* Standard Tivoli STorage Manager API header.      */
#include "dsmapifp.h"
#include "dapitype.h"        /* Sample API data types.        */
#include "dapint64.h"        /* 64 bit integer functions.     */
#include "dapiutil.h"        /* Handy utility routines.       */
#include "dapiproc.h"

/*----------------------------------------------------------------------+
| Name:    format_number()
|
| Action:  Take a asciiz string and format it with commas for readability.
|          Converts 123456789 to 123,456,789
|
| Input:   *s_in - Pointer to input character string.
|
| Output:  *s_out - Pointer to output character buffer.
|
| Returns: None
|
| Side
| Effects: None
|
| Notes:   This routine handles formatted numbers up to 49 characters in
|          length, thus buffers of 50 bytes need be passed for the routine
|          to work.
+----------------------------------------------------------------------*/
void format_number(char *s_in, char *s_out)
{
char  *save;
char temp[50];           /* Should be long enough for most numbers.      */
int i;
char separator = ',';    /* This could be a period in other countries.   */

if (!*s_in)
  {*s_out = 0x00; return;}

save = s_in;           /* Remember where it started.                */
s_in += strlen(s_in);  /* Point to end of string.                   */

i = 48;
temp[49] = 0;
while (s_in != save)
  {
  temp[i--] = (*s_in--);
  if (i%4==0) temp[i--] = separator;
  }
temp[i] = (*s_in);
strcpy(s_out,temp+i);
}
/*----------------------------------------------------------------------+
| Name:    initFS()        
|
| Action:  Fill in platform specific filespace info                        
|          
+----------------------------------------------------------------------*/
void initFS(regFSData *fsDataP)
{
strcpy(fsDataP->fsAttr.unixFSAttr.fsInfo,"Sample API FS Info");
fsDataP->fsAttr.unixFSAttr.fsInfoLength =
       strlen(fsDataP->fsAttr.unixFSAttr.fsInfo) + 1;

}

/*----------------------------------------------------------------------+
| Name:    ourGetS()        
|
| Action:  Perform a gets() and display the input if preference
|          echo_in is set to bTrue.
|          
+----------------------------------------------------------------------*/
void ourGetS(char *buf)
{
   int i;

   if (fgets(buf, INPUT_BUFFER_SIZE-1, stdin))
   {
      /* removes the '\n' character that is not part of the input */
      for(i=0 ; i<INPUT_BUFFER_SIZE-1 ; i++)
      {
         if(buf[i] == '\n')
         {
            buf[i]='\0';
            break;
         }
      }
      if (pref.echo_in == bTrue)
         printf("%s\n", buf);
   }
}

/*----------------------------------------------------------------------+
| Name:    ourGetString()        
|
| Action:  Perform a fgets() and display the input if preference
|          echo_in is set to bTrue.
|          
+----------------------------------------------------------------------*/

void ourGetString(char *buf,int bufferLength)
{
   char buffer[INPUT_BUFFER_SIZE]; /*=== must be long enough for manual typing ===*/
   int  i;

   /*=== get a string from user input ===*/
   if (fgets(buffer,INPUT_BUFFER_SIZE-1,stdin))
   {
      /*=== copy it to the user buffer ===*/
      strncpy(buf,buffer,bufferLength-1);

      /*=== convert the \n to a \0 character ===*/
      for(i=0;i<bufferLength;i++)
      {
         if(buf[i] == '\n')
            buf[i] = '\0';
      }

      if (pref.echo_in == bTrue)
         printf("%s\n", buf);
   }
}

/*----------------------------------------------------------------------+
| Name:    FSInfoResp()
|
| Action:  Fill in platform specific filespace info
|
+----------------------------------------------------------------------*/
void FSInfoResp(char *fs_info, qryRespFSData *fsResp)
{
      memcpy(fs_info, fsResp->fsAttr.unixFSAttr.fsInfo,
                             fsResp->fsAttr.unixFSAttr.fsInfoLength);
      memcpy(fs_info+fsResp->fsAttr.unixFSAttr.fsInfoLength,
                           "\0", 1); /* NULL term */
}

/*-------------------------------------------------------------+
| Name:  UpdateFileSpace()
| 
| Action:  Fill in platform specific filespace info.
|          This function is UNIX specific function.
+-------------------------------------------------------------*/

void UpdateFileSpace(dsmFSUpd *fsDataP, char *fsinfo)
{
   strcpy(fsDataP->fsAttr.unixFSAttr.fsInfo, fsinfo);
   fsDataP->fsAttr.unixFSAttr.fsInfoLength =
   strlen(fsDataP->fsAttr.unixFSAttr.fsInfo) + 1;
}

/*----------------------------------------------------------------------+
| Name:    perform_sleep()
|
| Action:  Take the information passed in the dialog to this function,
|          sleep for specified number of seconds.
|
| Input:   sel_dialog  - Pointer to dialog table to process.
|
| Returns: 0                 - Successful
|
| Side
| Effects: None
|
| Notes:   None
+----------------------------------------------------------------------*/
dsInt16_t perform_sleep(dialog *sel_dialog,dsUint16_t parm1)
{

dsUint16_t     i;
dsUint32_t     sleepTime;
dialog         *dlg;
dsStruct64_t   sleepTime64 = dMake64(0);

i = 0;
dlg = &sel_dialog[i];
while (dlg->item_type != DSMAPI_END)
{
   switch (dlg->item_type)
   {
     case DSMAPI_SLEEP :
         sleepTime64 = dChtoI64(dlg->item_buff,10);
         sleepTime   = sleepTime64.lo;
         break;
   }
   i++;
   dlg = &sel_dialog[i];
}

sleep(sleepTime);

return 0;
}

