/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SOUND_H
#define SOUND_H     1

#include <alsa/asoundlib.h>
#include "common.h"
#include "image.h"
#include "display.h"

#define PERIOD_SIZE         4096 /* Number of frames per readi() */
#define NUM_PERIODS            4 /* Number of periods */
#define SYNC_DETECT           16 /* Sync-detected threshold (samples) */
#define SYNC_ACCEPT            8 /* Accept sample rate error (carrier samples) */
#define RATE_OK_COUNT          8 /* Number of consecutive rate measurements */
#define CARRIER_FREQ        2400 /* APT carrier frequency (2.4KHz) */
#define SND_DSP_RATE       48000 /* DSP recording speed in samples/sec */
#define BLOCK_BUFFER_SIZE  24200 /* Signal buffer size=samples/line+200 */
#define BLOCK_SIZE         24000 /* Read block size samples/line */
#define EXACT_VAL              0 /* Set exact params */
#define SND_PCM_ACCESS  SND_PCM_ACCESS_RW_INTERLEAVED
#define SND_PCM_FORMAT  SND_PCM_FORMAT_S16_LE

/* To scale input to signal scope display */
#define SCOPE_SCALE     218

#endif

