/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.fontmap;

import java.awt.Font;
import java.util.ArrayList;
import java.util.BitSet;
import javax.swing.JLabel;

public class FontMapEntry {
    private BitSet codePoints = new BitSet();
    private Font font = new JLabel().getFont();

    public BitSet codePoints() {
        return this.codePoints;
    }

    public String getCodePointsString() {
        int[] nArray = null;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n = 0;
        while ((n = this.codePoints.nextSetBit(n)) >= 0) {
            if (nArray != null && nArray[1] == n - 1) {
                nArray[1] = nArray[1] + true;
            } else {
                nArray = new int[]{n, n};
                arrayList.add(nArray);
            }
            ++n;
        }
        n = 1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int[] nArray2 : arrayList) {
            if (n != 0) {
                n = 0;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.toHexString(nArray2[0]));
            if (nArray2[0] == nArray2[1]) continue;
            stringBuffer.append("-");
            stringBuffer.append(this.toHexString(nArray2[1]));
        }
        return stringBuffer.toString();
    }

    public void setCodePointsString(String string) {
        this.codePoints.clear();
        for (String string2 : string.split(",")) {
            if (string2.contains("-")) {
                String[] stringArray = string2.split("-", 2);
                try {
                    int n = this.parseHexInt(stringArray[0]);
                    int n2 = this.parseHexInt(stringArray[1]);
                    this.codePoints.set(n, n2 + 1);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            try {
                int n = this.parseHexInt(string2);
                this.codePoints.set(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getFontString() {
        return this.font.getFamily();
    }

    public void setFontString(String string) {
        this.font = new Font(string, this.font.getStyle(), this.font.getSize());
    }

    public boolean containsAllCodePoints(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (this.codePoints.get(n)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAnyCodePoints(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!this.codePoints.get(n)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof FontMapEntry) {
            FontMapEntry fontMapEntry = (FontMapEntry)object;
            return this.codePoints.equals(fontMapEntry.codePoints) && this.font.equals(fontMapEntry.font);
        }
        return false;
    }

    public int hashCode() {
        return this.codePoints.hashCode() ^ this.font.hashCode();
    }

    public String toString() {
        return this.getCodePointsString() + " -> " + this.getFontString();
    }

    private int parseHexInt(String string) {
        if ((string = string.trim()).startsWith("U+") || string.startsWith("u+")) {
            string = string.substring(2).trim();
        }
        return Integer.parseInt(string, 16);
    }

    private String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        while (string.length() < 4) {
            string = "0" + string;
        }
        return string;
    }
}

