/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.UnicodeUtils;
import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
extends AbstractList<Integer>
implements Comparable<Block> {
    public final int firstCodePoint;
    public final int lastCodePoint;
    public final String name;

    public Block(int n, int n2, String string) {
        this.firstCodePoint = n;
        this.lastCodePoint = n2;
        this.name = string;
    }

    @Override
    public int size() {
        return this.lastCodePoint - this.firstCodePoint + 1;
    }

    @Override
    public Integer get(int n) {
        return this.firstCodePoint + n;
    }

    @Override
    public boolean contains(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return n >= this.firstCodePoint && n <= this.lastCodePoint;
        }
        return false;
    }

    @Override
    public int indexOf(Object object) {
        int n;
        if (object instanceof Integer && (n = ((Integer)object).intValue()) >= this.firstCodePoint && n <= this.lastCodePoint) {
            return n - this.firstCodePoint;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n;
        if (object instanceof Integer && (n = ((Integer)object).intValue()) >= this.firstCodePoint && n <= this.lastCodePoint) {
            return n - this.firstCodePoint;
        }
        return -1;
    }

    @Override
    public int compareTo(Block block) {
        if (this.firstCodePoint != block.firstCodePoint) {
            return this.firstCodePoint - block.firstCodePoint;
        }
        if (block.lastCodePoint != this.lastCodePoint) {
            return block.lastCodePoint - this.lastCodePoint;
        }
        return UnicodeUtils.naturalCompare(this.name, block.name);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return this.firstCodePoint == block.firstCodePoint && this.lastCodePoint == block.lastCodePoint && this.name.equals(block.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.firstCodePoint + this.lastCodePoint + this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

