/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.u8m;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class U8MGlyph {
    public int bitmapLocation;
    public int advanceWidth;
    public int yOffset;
    public int xOffset;
    public int height;
    public int width;
    public byte[] data;

    public void from2DArray(byte[][] byArray) {
        if (byArray == null || byArray.length == 0) {
            this.height = 0;
            this.width = 0;
            this.data = new byte[0];
        } else {
            this.height = byArray.length;
            this.width = byArray[0].length;
            this.data = new byte[(this.height * this.width + 7) / 8];
            int n = 0;
            int n2 = 128;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    if (byArray[i][j] < 0) {
                        int n3 = n;
                        this.data[n3] = (byte)(this.data[n3] | n2);
                    }
                    if ((n2 >>= 1) != 0) continue;
                    n2 = 128;
                    ++n;
                }
            }
        }
    }

    public byte[][] to2DArray() {
        byte[][] byArray = new byte[this.height][this.width];
        if (this.data != null) {
            int n = 0;
            int n2 = 128;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n3 = byArray[i][j] = (this.data[n] & n2) == 0 ? 0 : -1;
                    if ((n2 >>= 1) != 0) continue;
                    n2 = 128;
                    ++n;
                }
            }
        }
        return byArray;
    }

    public int setBitmapLocation(int n) {
        if (this.data == null || this.data.length == 0) {
            this.bitmapLocation = 0;
            return n;
        }
        int n2 = this.data.length + 4;
        if ((n & 0xFF) + n2 > 256) {
            n = (n | 0xFF) + 1;
        }
        this.bitmapLocation = n;
        return this.bitmapLocation + n2;
    }

    public void readGlyphRecord(DataInput dataInput) throws IOException {
        int n = Integer.reverseBytes(dataInput.readInt());
        this.bitmapLocation = n & 0xFFFFFF;
        this.advanceWidth = n >> 24 & 0xFF;
    }

    public void writeGlyphRecord(DataOutput dataOutput) throws IOException {
        int n = this.bitmapLocation & 0xFFFFFF | this.advanceWidth << 24;
        dataOutput.writeInt(Integer.reverseBytes(n));
    }

    public void readBitmapRecord(DataInput dataInput) throws IOException {
        this.yOffset = dataInput.readByte();
        this.xOffset = dataInput.readByte();
        this.height = dataInput.readUnsignedByte();
        this.width = dataInput.readUnsignedByte();
        this.data = new byte[(this.height * this.width + 7) / 8];
        dataInput.readFully(this.data);
    }

    public void writeBitmapRecord(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.yOffset);
        dataOutput.writeByte(this.xOffset);
        dataOutput.writeByte(this.height);
        dataOutput.writeByte(this.width);
        if (this.data != null) {
            dataOutput.write(this.data);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof U8MGlyph) {
            U8MGlyph u8MGlyph = (U8MGlyph)object;
            return this.advanceWidth == u8MGlyph.advanceWidth && this.yOffset == u8MGlyph.yOffset && this.xOffset == u8MGlyph.xOffset && this.height == u8MGlyph.height && this.width == u8MGlyph.width && U8MGlyph.equals(this.data, u8MGlyph.data);
        }
        return false;
    }

    private static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0) {
            return byArray2 == null || byArray2.length == 0;
        }
        if (byArray2 == null || byArray2.length == 0) {
            return byArray == null || byArray.length == 0;
        }
        return Arrays.equals(byArray, byArray2);
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.advanceWidth, this.yOffset, this.xOffset, this.height, this.width, this.data == null || this.data.length == 0 ? 0 : Arrays.hashCode(this.data)});
    }
}

