/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class HeadTable
extends TrueTypeTable {
    public static final int VERSION_DEFAULT = 65536;
    public static final int MAGIC_NUMBER = 1594834165;
    public static final int FLAGS_Y_VALUE_OF_ZERO_SPECIFIES_BASELINE = 1;
    public static final int FLAGS_MINIMUM_X_VALUE_IS_LEFT_SIDE_BEARING = 2;
    public static final int FLAGS_SCALED_AND_ACTUAL_POINT_SIZE_DIFFER = 4;
    public static final int FLAGS_USE_INTEGER_SCALING = 8;
    public static final int FLAGS_USED_BY_MICROSOFT = 16;
    public static final int FLAGS_X_VALUE_OF_ZERO_SPECIFIES_BASELINE = 32;
    public static final int FLAGS_MUST_BE_ZERO = 64;
    public static final int FLAGS_REQUIRES_LAYOUT_FOR_CORRECT_RENDERING = 128;
    public static final int FLAGS_METAMORPHOSIS_EFFECT_BY_DEFAULT = 256;
    public static final int FLAGS_CONTAINS_RIGHT_TO_LEFT_GLYPHS = 512;
    public static final int FLAGS_CONTAINS_INDIC_STYLE_REARRANGEMENT = 1024;
    public static final int FLAGS_DEFINED_BY_ADOBE_1 = 2048;
    public static final int FLAGS_DEFINED_BY_ADOBE_2 = 4096;
    public static final int FLAGS_DEFINED_BY_ADOBE_3 = 8192;
    public static final int FLAGS_GENERIC_SYMBOLS_FOR_CODE_POINT_RANGES = 16384;
    public static final long DATE_EPOCH = new GregorianCalendar(1904, 0, 1, 0, 0, 0).getTimeInMillis();
    public static final int MAC_STYLE_PLAIN = 0;
    public static final int MAC_STYLE_BOLD = 1;
    public static final int MAC_STYLE_ITALIC = 2;
    public static final int MAC_STYLE_BOLD_ITALIC = 3;
    public static final int MAC_STYLE_UNDERLINE = 4;
    public static final int MAC_STYLE_OUTLINE = 8;
    public static final int MAC_STYLE_SHADOW = 16;
    public static final int MAC_STYLE_CONDENSED = 32;
    public static final int MAC_STYLE_EXTENDED = 64;
    public static final int MAC_STYLE_GROUPED = 128;
    public static final int FONT_DIRECTION_HINT_MIXED = 0;
    public static final int FONT_DIRECTION_HINT_ONLY_LTR = 1;
    public static final int FONT_DIRECTION_HINT_LTR_WITH_NEUTRAL = 2;
    public static final int FONT_DIRECTION_HINT_ONLY_RTL = -1;
    public static final int FONT_DIRECTION_HINT_RTL_WITH_NEUTRAL = -2;
    public static final int INDEX_TO_LOC_FORMAT_SHORT = 0;
    public static final int INDEX_TO_LOC_FORMAT_LONG = 1;
    public static final int GLYPH_DATA_FORMAT_DEFAULT = 0;
    public int version = 65536;
    public int fontRevision = 0;
    public int checkSum = 0;
    public int magicNumber = 1594834165;
    public int flags = 0;
    public int unitsPerEm = 0;
    public long dateCreated = 0L;
    public long dateModified = 0L;
    public int xMin = 0;
    public int yMin = 0;
    public int xMax = 0;
    public int yMax = 0;
    public int macStyle = 0;
    public int lowestRecPPEM = 0;
    public int fontDirectionHint = 0;
    public int indexToLocFormat = 0;
    public int glyphDataFormat = 0;

    public String tableName() {
        return "head";
    }

    public String[] dependencyNames() {
        return new String[0];
    }

    public double getFontRevisionDouble() {
        return (double)this.fontRevision / 65536.0;
    }

    public void setFontRevisionDouble(double d) {
        this.fontRevision = (int)Math.round(d * 65536.0);
    }

    public GregorianCalendar getDateCreatedCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(DATE_EPOCH + this.dateCreated * 1000L);
        return gregorianCalendar;
    }

    public void setDateCreatedCalendar(Calendar calendar) {
        this.dateCreated = (calendar.getTimeInMillis() - DATE_EPOCH) / 1000L;
    }

    public GregorianCalendar getDateModifiedCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(DATE_EPOCH + this.dateModified * 1000L);
        return gregorianCalendar;
    }

    public void setDateModifiedCalendar(Calendar calendar) {
        this.dateModified = (calendar.getTimeInMillis() - DATE_EPOCH) / 1000L;
    }

    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(this.fontRevision);
        dataOutputStream.writeInt(this.checkSum);
        dataOutputStream.writeInt(this.magicNumber);
        dataOutputStream.writeShort(this.flags);
        dataOutputStream.writeShort(this.unitsPerEm);
        dataOutputStream.writeLong(this.dateCreated);
        dataOutputStream.writeLong(this.dateModified);
        dataOutputStream.writeShort(this.xMin);
        dataOutputStream.writeShort(this.yMin);
        dataOutputStream.writeShort(this.xMax);
        dataOutputStream.writeShort(this.yMax);
        dataOutputStream.writeShort(this.macStyle);
        dataOutputStream.writeShort(this.lowestRecPPEM);
        dataOutputStream.writeShort(this.fontDirectionHint);
        dataOutputStream.writeShort(this.indexToLocFormat);
        dataOutputStream.writeShort(this.glyphDataFormat);
    }

    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        this.version = dataInputStream.readInt();
        this.fontRevision = dataInputStream.readInt();
        this.checkSum = dataInputStream.readInt();
        this.magicNumber = dataInputStream.readInt();
        this.flags = dataInputStream.readUnsignedShort();
        this.unitsPerEm = dataInputStream.readUnsignedShort();
        this.dateCreated = dataInputStream.readLong();
        this.dateModified = dataInputStream.readLong();
        this.xMin = dataInputStream.readShort();
        this.yMin = dataInputStream.readShort();
        this.xMax = dataInputStream.readShort();
        this.yMax = dataInputStream.readShort();
        this.macStyle = dataInputStream.readUnsignedShort();
        this.lowestRecPPEM = dataInputStream.readUnsignedShort();
        this.fontDirectionHint = dataInputStream.readShort();
        this.indexToLocFormat = dataInputStream.readShort();
        this.glyphDataFormat = dataInputStream.readShort();
    }
}

