/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.EblcGlyphIdOffsetPair;
import com.kreative.bitsnpicas.truetype.ListBasedEblcIndexSubtable;
import com.kreative.bitsnpicas.truetype.SbitBigGlyphMetrics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EblcIndexSubtable5
extends ListBasedEblcIndexSubtable<Integer> {
    public int imageSize;
    public SbitBigGlyphMetrics bigMetrics;

    @Override
    protected void read(DataInputStream dataInputStream) throws IOException {
        this.imageSize = dataInputStream.readInt();
        this.bigMetrics = new SbitBigGlyphMetrics();
        this.bigMetrics.read(dataInputStream);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(dataInputStream.readUnsignedShort());
        }
    }

    @Override
    protected void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.imageSize);
        (this.bigMetrics != null ? this.bigMetrics : new SbitBigGlyphMetrics()).write(dataOutputStream);
        dataOutputStream.writeInt(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            dataOutputStream.writeShort(n);
        }
        if ((this.size() & 1) != 0) {
            dataOutputStream.writeShort(0);
        }
    }

    @Override
    protected int length() {
        int n = 16 + this.size() * 2;
        if ((this.size() & 1) != 0) {
            n += 2;
        }
        return n;
    }

    @Override
    public int[] getOffsets() {
        int n = this.size() + 1;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i * this.imageSize + this.header.imageDataOffset;
        }
        return nArray;
    }

    @Override
    public void setOffsets(int[] nArray) {
        this.imageSize = nArray[1] - nArray[0];
    }

    @Override
    public EblcGlyphIdOffsetPair[] getGlyphIdOffsetPairs() {
        int n = this.size() + 1;
        EblcGlyphIdOffsetPair[] eblcGlyphIdOffsetPairArray = new EblcGlyphIdOffsetPair[n];
        for (int i = 0; i < n; ++i) {
            eblcGlyphIdOffsetPairArray[i] = new EblcGlyphIdOffsetPair();
            eblcGlyphIdOffsetPairArray[i].glyphID = i < this.size() ? (Integer)this.get(i) : -1;
            eblcGlyphIdOffsetPairArray[i].offset = i * this.imageSize + this.header.imageDataOffset;
        }
        return eblcGlyphIdOffsetPairArray;
    }

    @Override
    public void setGlyphIdOffsetPairs(EblcGlyphIdOffsetPair[] eblcGlyphIdOffsetPairArray) {
        this.header.firstGlyphIndex = eblcGlyphIdOffsetPairArray[0].glyphID;
        this.header.lastGlyphIndex = eblcGlyphIdOffsetPairArray[0].glyphID;
        this.clear();
        for (EblcGlyphIdOffsetPair eblcGlyphIdOffsetPair : eblcGlyphIdOffsetPairArray) {
            if (eblcGlyphIdOffsetPair.glyphID < this.header.firstGlyphIndex) {
                this.header.firstGlyphIndex = eblcGlyphIdOffsetPair.glyphID;
            }
            if (eblcGlyphIdOffsetPair.glyphID > this.header.lastGlyphIndex) {
                this.header.lastGlyphIndex = eblcGlyphIdOffsetPair.glyphID;
            }
            this.add(eblcGlyphIdOffsetPair.glyphID);
        }
        this.imageSize = eblcGlyphIdOffsetPairArray[1].offset - eblcGlyphIdOffsetPairArray[0].offset;
    }
}

