/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.EblcGlyphIdOffsetPair;
import com.kreative.bitsnpicas.truetype.ListBasedEblcIndexSubtable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EblcIndexSubtable1
extends ListBasedEblcIndexSubtable<Integer> {
    @Override
    protected void read(DataInputStream dataInputStream) throws IOException {
        int n = this.header.lastGlyphIndex - this.header.firstGlyphIndex + 2;
        for (int i = 0; i < n; ++i) {
            this.add(dataInputStream.readInt());
        }
    }

    @Override
    protected void write(DataOutputStream dataOutputStream) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            dataOutputStream.writeInt(n);
        }
    }

    @Override
    protected int length() {
        return this.size() * 4;
    }

    @Override
    public int[] getOffsets() {
        int n = this.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)this.get(i) + this.header.imageDataOffset;
        }
        return nArray;
    }

    @Override
    public void setOffsets(int[] nArray) {
        this.clear();
        for (int n : nArray) {
            this.add(n - this.header.imageDataOffset);
        }
    }

    @Override
    public EblcGlyphIdOffsetPair[] getGlyphIdOffsetPairs() {
        int n = this.size();
        EblcGlyphIdOffsetPair[] eblcGlyphIdOffsetPairArray = new EblcGlyphIdOffsetPair[n];
        for (int i = 0; i < n; ++i) {
            eblcGlyphIdOffsetPairArray[i] = new EblcGlyphIdOffsetPair();
            eblcGlyphIdOffsetPairArray[i].glyphID = this.header.firstGlyphIndex + i;
            eblcGlyphIdOffsetPairArray[i].offset = (Integer)this.get(i) + this.header.imageDataOffset;
        }
        return eblcGlyphIdOffsetPairArray;
    }

    @Override
    public void setGlyphIdOffsetPairs(EblcGlyphIdOffsetPair[] eblcGlyphIdOffsetPairArray) {
        this.header.firstGlyphIndex = eblcGlyphIdOffsetPairArray[0].glyphID;
        this.header.lastGlyphIndex = eblcGlyphIdOffsetPairArray[0].glyphID + eblcGlyphIdOffsetPairArray.length - 2;
        this.clear();
        for (EblcGlyphIdOffsetPair eblcGlyphIdOffsetPair : eblcGlyphIdOffsetPairArray) {
            this.add(eblcGlyphIdOffsetPair.offset - this.header.imageDataOffset);
        }
    }
}

